﻿//メインパーサの正規表現
var re_Main = /<TITLE>((?:([0-9][0-9])\s+)?(.*?)[（(](.*)[）)])(?:[ 　]|&nbsp;)*(現代語訳|与謝野晶子訳)?<\/TITLE>|<H3>(.*)<\/H3>|<P class=wakaAkiko>(.*)|<ADDRESS>((?:.*\n)*?.*?)(?:<BR>)?<\/ADDRESS>|((<BR>)?\n(?:<P>|\s|　|&nbsp;)*)(?:(?:<H4>(.*)<\/H4>|<A name="?in([0-9]*)"?>(?:\[(.+)\])<\/A>)(?=(?:<BR>)?\n))?|<RUBY><RB>([^<>]*)(?:<\/RB>)?(?:<RP>[^<>]*(?:<\/RP>)?)?<RT>([^<>]*)(?:<\/RT>)?(?:<RP>[^<>]*(?:<\/RP>)?)?<\/RUBY>|<!--(.*?)-->|<(\/?\w+).*?>|([a-zA-Z0-9_<>&;="''"\/]+)/gi

var wholeFile = null;

var TextType = "与謝野晶子訳";

var Chapter = null;
var ChapterNo = -1;
var Paragraph = null;
var ParagraphNo = -1;

var lastEndPos = 0;
var copiedPos = 0;

var re_Main_dispatch_traceid = null;

function re_Main_dispatch(
	$0,
	foundTitle,       // $1 タイトル。「帖番号 帖名（底本）」の形式
	foundVolumeNo,    // $2 帖番号
	foundVolumeName,  // $3 帖名
	foundSourceBook,// 底本
	foundTextType,  // 本文|注釈|現代語訳|与謝野晶子訳|Japanese roman letters
	foundVolumeNameH3,// 帖番号 帖名。「01 桐壺」の形式。<H3>タグより取得。
	foundWakaAkiko, // 与謝野晶子による和歌。与謝野晶子訳にのみ存在する。<P class=wakaAkiko>タグより取得。夕霧の帖以外は１句/帖。与謝野晶子訳では夕霧の帖は２つに分かれているため２句ある。
	foundAddress,   // 著作権情報。<ADDRESS>タグより取得。ほとんどすべてが複数行にまたがっている。
	foundNL,               // 上記のいずれにも含まれない改行を検出したことをあらわす。
	foundBR,
	foundChapterName,    // 章名。<H4>タグより取得。
	foundA_name_inNN,    // 段のアンカー番号。以下、段名まで<A name="inNN">タグより取得。
	foundParagraphName,  // 段名
	foundRuby_RB,
	foundRuby_RT,
	foundHtmlComment,      // $31 HTMLコメント
	foundOtherTag,         // $30 その他のHTMLタグが見つかったとき、そのタグ名。終了タグの場合'/'で始まる。その他のタグはタグ名の英数字部分のみ。
	foundUnknownText,      // テキスト
	pos)
{
	var ret=$0;
	if(Paragraph != null) {
		putXml(wholeFile.substring(lastEndPos, pos));
	}
	if(foundVolumeName && foundVolumeName!="") {
		//  foundTitle:      $2 タイトル。「帖名（底本）」の形式。以下、$5まで<TITLE>タグより取得。
		//  foundVolumeName: $3 帖名
		//  foundSourceBook: $4 底本
		//  foundTextType:   $5 本文|ローマ字版|現代語訳|注釈 (与謝野晶子訳にも「現代語訳」と入っている)
		//帖名の設定
		if(Paragraph) ret=ErrorRed($0);
		oVolume.title = foundTitle;
		putXml('<帖 title="'+foundTitle+'">\n');
	}
	else if(foundVolumeNameH3 && foundVolumeNameH3!="") {
		//  foundVolumeNameH3: $6 帖名。<H3>タグより取得。
		//帖名-2の設定
		if(Paragraph) ret=ErrorRed($0);;
	}
	else if(foundWakaAkiko && foundWakaAkiko!="") {
		//  foundWakaAkiko:  $7 与謝野晶子による和歌。与謝野晶子訳にのみ存在する。<P class=wakaAkiko>タグより取得。
		//  夕霧の帖以外は１句/帖。与謝野晶子訳では夕霧の帖は２つに分かれているため２句ある。(未対応)
		oVolume.wakaAkiko = foundWakaAkiko;
	}
	else if(foundAddress && foundAddress!="") {
		//  foundAddress:    $8 著作権情報。<ADDRESS>タグより取得。ほとんどすべてが複数行にまたがっている。
	}
	else if(foundChapterName && foundChapterName!="") {
		//  foundChapterName: $14 章名。<H4>タグより取得。
		if(Paragraph != null) {
			Paragraph.endpos[TextType] = copiedPos;
			Paragraph = null;
		}
		//章の開始
		ChapterNo++;
		ParagraphNo=0;
		Paragraph = null;
		if(ChapterNo==oVolume.Chapters.length || oVolume.Chapters.length==0) {
			var chapter = new Array();
			chapter.no = ChapterNo;
			chapter.id = ChapterNo;
			chapter.name = foundChapterName;
			chapter.name2 = "";
			chapter.Paragraphs = new Array();
			Chapter = oVolume.Chapters[ChapterNo] = chapter;
		}
		else if(ChapterNo<oVolume.Chapters.length) {
			Chapter = oVolume.Chapters[ChapterNo];
			//章名の設定
			Chapter.name = foundChapterName;
		}
		else {
			Chapter = null;
		}
		if(Chapter != null) {
			putXml((ChapterNo==1?"":"\n</段>\n</章>")+"\n<章 no=\""+ChapterNo+"\" name=\""+foundChapterName+"\">\n");
		}
	}
	else if(foundA_name_inNN && foundA_name_inNN!="") {
		//  foundA_name_inNN:    $15 段・出典・校訂のアンカー番号。以下、段名まで<A name="inNN">タグより取得。
		//  foundShuttennKoutei: $16 (出典|校訂)
		//  foundParagraphName:  $17 段名
		if(foundParagraphName) {
			if(foundParagraphName=="") debug.debug();
			if(Paragraph != null) {
				Paragraph.endpos[TextType] = copiedPos;
				Paragraph = null;
			}
			//段のアンカー⇒段の開始
			ParagraphNo++;
			if(ParagraphNo==Chapter.Paragraphs.length || Chapter.Paragraphs.length==0) {
				var paragraph = new Array();
				paragraph.no = ParagraphNo
				paragraph.id = Chapter.id+"."+ParagraphNo;
				paragraph.hrefid = foundA_name_inNN;
				paragraph.name = foundParagraphName;
				paragraph.name2 = "";
				paragraph.images = new Array();
				paragraph.pos = new Array();
				paragraph.endpos = new Array();
				paragraph.LineNo = 0; // 段内LineNo。段の先頭には改行があるので、LineNoは実質１始まりになる。
				oVolume.cntParagraphs++;
				Paragraph = Chapter.Paragraphs[ParagraphNo] = paragraph;
			}
			else if(ParagraphNo < Chapter.Paragraphs.length) {
				Paragraph = Chapter.Paragraphs[ParagraphNo];
				if(Paragraph==null) ret=ErrorRed($0);
				else {
					Paragraph.LineNo = 0; // 段内LineNo。段の先頭には改行があるので、LineNoは実質１始まりになる。
					if(Paragraph.hrefid != foundA_name_inNN) debug.debug();
					//段名の設定
					Paragraph.name = foundParagraphName;
				}
			}
			else {
				Paragraph = null;
			}
			if(Paragraph != null) {
				putXml((ParagraphNo==1?"":"\n</段>")+"\n<段 no=\""+ParagraphNo+"\" name=\""+foundParagraphName+"\">\n");
				Paragraph.pos[TextType] = copiedPos+ret.length;
			}
		}
	}
	else if(foundNL && foundNL!="") {
		//  foundNL:         $1 NL。他のいずれにも含まれない改行を検出したことをあらわす。
		NL_Proc(copiedPos);
		if(Paragraph) {
			if(foundBR==null || foundBR=="") ret = ErrorRed("{{<BR>が無い}}"+$0);
		}
	}
	else if(foundRuby_RB && foundRuby_RB!="") {
		// ルビ
		ret = "<RUBY><RB>"+foundRuby_RB+"</RB><RP>（</RP><RT>"+foundRuby_RT+"</RT><RP>）</RP></RUBY>";
		putXml(foundRuby_RB);
	}
	else if(foundOtherTag && foundOtherTag!="") {
		//  foundOtherTag:    $30 その他のHTMLタグが見つかったとき、そのタグ名。終了タグの場合'/'で始まる。その他のタグはタグ名の英数字部分のみ。
		if(Paragraph) {
			switch(foundOtherTag) {
			case "span":
			case "/span":
				break;
			case "/BODY":
			case "HR":
				if(Paragraph != null) {
					Paragraph = null;
					putXml("\n</段>\n</章>\n</帖>\n");
				}
				break;
			default:
				ret = ErrorRed($0);
				break;
			}
		}
	}
	else if(foundHtmlComment && foundHtmlComment!="") {
		//  foundHtmlComment: $31 HTMLコメント
	}
	else if(foundUnknownText && foundUnknownText!="") {
		if(Paragraph) {
			ret = ErrorRed($0);
		}
	}
	lastEndPos = pos + $0.length;
	return ret;
}

function Volume(no)
{
	this.no = no;        // "01"
	this.name = "";      // "桐壺"
	this.title = "";     // "01 桐壺"
	this.title2 = "";    // "01 KIRITSUBO"
	this.subtitle = "";
	this.subtitle2 = "";
	this.notenocnt = 0;
	this.Chapters = new Array();
	this.Keywords = new Array();
	this.Descriptions = new Array();
	this.cnt = new Array();
}

function NL_Proc(pos)
{
	if(Paragraph) {
		Paragraph.LineNo = Paragraph.LineNo + 1; //段内LineNo。各段の先頭には改行があるので、LineNoは実質１始まりになる。
		Paragraph.currLineid = Paragraph.id+"."+Paragraph.LineNo;//行ＩＤを採番
		putXml("\n<行 no=\""+Paragraph.LineNo+"\"/>");
	}
}

function parseGenjiVolume(infilename, prmTextType)
{
	Chapter = null;
	ChapterNo = 0;
	Paragraph = null;
	ParagraphNo = 0;
	var currPerson = null;
	var address = false;

	TextType = prmTextType;
	
	wholeFile = ReadWholeFile(infilename).replace(/\r/g, "");
	lastEndPos = 0;
	copiedPos = 0;
	if(oVolume.wholeText==null) oVolume.wholeText = new Array();
	oVolume.wholeText[TextType] = wholeFile.replace(re_Main, re_Main_dispatch);
	WriteWholeFile(yosanoHtmlOutputFilename,xmlHeader+oVolume.wholeText[TextType]);
}

function MainParserXml(no)
{
	oVolume = new Volume(no);

	var yosanoFilename           = yosanodir + "yosano" +no+".html";
	if(fso.FileExists(yosanoFilename)) {
		yosanoHtmlOutputFilename = yosano2dir + "chk/yosano" +no+".chk.html";
		yosanoXmlOutputFilename  = yosano2dir + "chk/yosano" +no+".chk.xml";
		CreateParentFolder(yosanoXmlOutputFilename);
		fpYosanoXmlOutputFile = new MyStreamWriter(yosanoXmlOutputFilename);
		putXml(xmlHeader);
		parseGenjiVolume(yosanoFilename,  "与謝野晶子訳");
		fpYosanoXmlOutputFile.close();
	}
	else {
		MyLog("ファイル("+yosanoFilename+")が見つかりません。");
		myReportWriter.write("ファイル("+yosanoFilename+")が見つかりません。\n");
	}
}

function putXml(str)
{
	fpYosanoXmlOutputFile.write(str);
}

function ErrorRed(str)
{
	return '<FONT color="red">'+str.replace(/[<>&\n]/g,
		function($0) {
			switch($0) {
				case '<': return '&lt;';
				case '>': return '&gt;';
				case '&': return '&amp;';
				case '\n': return '{改行}\n';
			}
			return $0;
		}
	)+'</FONT>\n';
}
