﻿var oVolume;
var address_yosano_const = "与謝野晶子訳 全訳源氏物語<BR>(角川文庫版)<BR>古典総合研究所で電子化";
var imgdir = "../eiri/"

/// 確認済み行数不一致一覧
var ConfirmedLineCountMismatches = new Array();
ConfirmedLineCountMismatches["03.1.5段の行数不一致 14：14：15：14"] = true;
ConfirmedLineCountMismatches["12.1.6段の行数不一致 10：10：11：10"] = true;
ConfirmedLineCountMismatches["12.3.2段の行数不一致 10：10：11：10"] = true;
ConfirmedLineCountMismatches["21.5.5段の行数不一致 19：19：20：19"] = true;
ConfirmedLineCountMismatches["41.3.1段の行数不一致 10：10：11：10"] = true;
ConfirmedLineCountMismatches["46.3.7段の行数不一致 3：3：4：3"] = true;
ConfirmedLineCountMismatches["53.4.2段の行数不一致 11：11：12：11"] = true;
ConfirmedLineCountMismatches["53.6.1段の行数不一致 9：9：10：9"] = true;

function Book(id)
{
	this.id = id;
	this.title = "";
	this.title2 = "";
	this.subtitle = "";
	this.subtitle2 = "";
	this.h3 = "";
	this.h3_2 = "";
	this.notenocnt = 0;
	this.Chapters = new Array();
	this.AppearedPeople = new Array();
	this.Sources = new Array();
	this.Revises = new Array();
	this["address_genbun"] = "";
	this["address_yakubun"] = "";
	this["address_yosano"] = "";
	this["address_roman"] = "";
	this["address_notes"] = "";
	this["address_image"] = "";
	this["intro_genbun"] = new Array();
	this["intro_yakubun"] = new Array();
	this["intro_roman"] = new Array();
	this["intro_notes"] = new Array();
	this.CombinedHtml = null;
	this.cntLines = 0;
	this.cntParagraphs = 0;
	this.cntSources = 0;
	this.cntRevises = 0;
	this.cntTankas = 0;
	this.cntUnmatchedNote = 0;
}

function Chapter(id, title)
{
	this.id = id;
	this.title = title;
	this.title2 = "";
	this.Paragraphs = new Array();
}

function Paragraph(id, hrefid, title)
{
	this.id = id;
	this.hrefid = hrefid;
	this.title = title;
	this.title2 = "";
	this.images = new Array();
	this["genbun"] = new Array();
	this["yakubun"] = new Array();
	this["yosano"] = new Array();
	this["roman"] = new Array();
	this["hiragana"] = new Array();
	this.notes = new Array();
	this.sources = new Array();
	this.revises = new Array();
	this.tankas = new Array();
	oVolume.cntParagraphs++;
}

function Note(noteno, keyword, comment)
{
	this.noteno = noteno;
	this.keyword = keyword;
	this.comment = comment;
	this.lineid  = null;
	this.refLines  = null;
	this.refLineno = null;
	this.found = 0;
}

function Source(hrefid, lineid, keyword, refLines, refLineno)
{
	this.hrefid  = hrefid;
	this.lineid  = lineid;
	this.keyword = keyword;
	this.refLines  = refLines;
	this.refLineno = refLineno;
	oVolume.cntSources++;
}

function Revise(hrefid, lineid, keyword, refLines, refLineno)
{
	this.hrefid  = hrefid;
	this.lineid  = lineid;
	this.keyword = keyword;
	this.refLines = refLines;
	this.refLineno = refLineno;
	oVolume.cntRevises++;
}

function Tanka(lineid, refLines, refLineno, lines)
{
	oVolume.cntTankas++;
	this.no = oVolume.cntTankas;
	this.lineid = lineid;
	this.kaminoku = null;
	this.shimonoku = null;
	this.refLines = refLines;
	this.refLineno = refLineno;
	this.lines = lines;
}

function cvTanka(classname, strLine, tanka)
{
	var texttype = classname.replace(/c\w+noku/, "");
	var genbun = "";
	var rtnstr = "";
	if(result=/^((?:[　 「『｢''""]|&nbsp;)*)(.+?)([」』｣''""]*<BR>)/.exec(strLine)) {//for text*.html
		rtnstr = result[1] + "<SPAN class=" + classname + ">" + result[2] + "</SPAN>"+ result[3]; 
		if(texttype=="Genbun") {
			genbun = result[2].replace(/<[^<>]*>/g,"");
			if(tanka.genbun==null) {
				tanka.genbun = genbun;
			}
			else {
				tanka.genbun = tanka.genbun + "<BR>" + genbun;
			}
		}
	}
	else {
		myReportWriter.writeln("和歌 " + tanka.lineid + " " + texttype + " 記述形式誤り<BR>");
	}
	return rtnstr;
}

function cvTanka1(classname, strLine, tanka)
{
	var texttype = classname;
	var kaminoku = "";
	var shumonoku = "";
	var rtnstr = "";
	if(result=/^((?:[　 「『｢''""]|&nbsp;)*)(.+?)([」』｣''""]*)<BR>((?:[　 「『｢''""]|&nbsp;)*)(.+?)([」』｣''""]*)<BR>/.exec(strLine)) {//for text*.html
		rtnstr = result[1] + "<SPAN class='cKaminoku"  + classname + "'>" + result[2] + "</SPAN>"+ result[3] + "<BR>"
		       + result[4] + "<SPAN class='cShimonoku" + classname + "'>" + result[5] + "</SPAN>"+ result[6] ;
		if(texttype=="Genbun") {
			if(tanka.genbun==null) {
				kaminoku  = result[2].replace(/<[^<>]*>/g,"");
				shumonoku = result[5].replace(/<[^<>]*>/g,"");
				tanka.genbun = kaminoku + "<BR>" + shumonoku;
			}
		}
	}
	else {
		myReportWriter.writeln("和歌 " + tanka.lineid + " " + classname + " 記述形式誤り<BR>");
	}
	if(rtnstr.match(/undefined/)) stop
	return rtnstr;
}

var AllPersons = new Array();

function Person(name, yomi)
{
	this.name = name;
	this.yomi = yomi;
	this.koshou = new Array();
	this.title = new Array();
}

function Intro(id, intro)
{
	this.id = id;
	this.intro = intro;
}

/// 漢数字変換
function ToChineseNumeral(No) 
{
		return ",十,二十,三十,四十,五十,七十,八十,九十".split(",")[Math.floor(No/10)]
		     + ",一,二,三,四,五,六,七,八,九".split(",")[No%10];
}

function parseGenjiBook(oVolume, infilename, LineType)
{
	var ChapterNo = -1;
	var ParagraphNo = -1;
	var oChapter = null;
	var oParagraph = null;
	var currPerson = null;
	var lastP = -1;
	var lastH3 = -1;
	var address = false;

	//var wholeFile = ReadWholeFile(infilename).replace(/([\r，．～ ])[ ]?/g,
	var wholeFile = ReadWholeFile(infilename).replace(/[\r]/g, "");
	if(LineType=="yakubun" || LineType=="genbun") {
		var lineno = 1;
		wholeFile = wholeFile.replace(/([，．～\n])[ ]?|([\u0100-\uFFFF][ ][\u0100-\uFFFF])/g,
			function($0,chr,sp,pos) {
				// 朗読用の文節情報を本文と渋谷栄一訳との間で対応付けるために、対応しない句読点が別の文字に変換されていたものを、元に戻す。
				switch(chr) {
				case "，": return "、";// 読点(、)が全角のカンマ(，)に変換されていたものを、元に戻す。
				case "．": return "。";// 句点(。)が全角のピリオド(．)に変換されていたものを、元に戻す。
				case "～": return "、";// 「四、五日」⇒「四～五日」のように変換されていたものを、元に戻す。(渋谷栄一訳のみ)
				case null:
				case "":
					if(lineno>=10) { // <TITLE>にマッチさせないため
						if(sp && sp.length==3) {
							return sp.substr(0,1) + sp.substr(2,1); // 半角空白が挿入されていたものを、元に戻す。
						}
						else stop;
					}
					break;
				case "\n":
					lineno ++;
					break;
				default:
					stop;
				}
				return $0;
			}
		);
	}
	if(LineType=="genbun") {
		//出典・校訂からの戻りのリンク入口⇒削除(lineidによる行頭へのリンクに変更するため)
		wholeFile = wholeFile.replace(/<A name="?te?[0-9]+"?>((?:<BR>)?\r?\n?[^<>]*)<\/A>/g, "$1");
	}
	var htmlLines = wholeFile.split("\n");
	
	//if(LineType=="yosano") debug.debug();

	for(line=0;line<htmlLines.length;++line) {
		var htmlLine = htmlLines[line];
		var result;
		if(htmlLine=="</BODY>") {
			break;
		}
		else if(result=/^(?:[ 　]|&nbsp;)*(<P>|<BR>)?(?:[ 　]|&nbsp;)*$/i.exec(htmlLine)) {
			lastP = line;
		}
		else if(result=/<H4>(.*)<\/H4>/i.exec(htmlLine)) {
			//章の開始
			ChapterNo++;
			ParagraphNo=-1;
			if(ChapterNo==oVolume.Chapters.length) {
				oChapter = oVolume.Chapters[ChapterNo] = new Chapter(/*oVolume.id+"."+*/(ChapterNo+1), result[1]);
			}
			else if(ChapterNo<oVolume.Chapters.length) {
				oChapter = oVolume.Chapters[ChapterNo];
				//章名の設定
				switch(LineType) {
				case "genbun":
					oChapter.title = result[1]+"";
					break;
				case "roman":
					oChapter.title2 = result[1]+"";
					break;
				default:
					if(oChapter.title=="") {
						oChapter.title = result[1]+"";
					}
					break;
				}
			}
			else {
				oChapter = null;
			}
			//docProgress.write(oVolume.title + " " + LineType + " " + result[1] + "<br>\n")
		}
		else if(result=/<A name="?in([0-9]*)"?>\[(.*)\]<\/A>/i.exec(htmlLine)) {
			//段のアンカー⇒段の開始
			ParagraphNo++;
			if(ParagraphNo==oChapter.Paragraphs.length) {
				oParagraph = oChapter.Paragraphs[ParagraphNo] = new Paragraph(oChapter.id+"."+(ParagraphNo+1), result[1], result[2]);
			}
			else if(ParagraphNo < oChapter.Paragraphs.length) {
				oParagraph = oChapter.Paragraphs[ParagraphNo];
				if(oParagraph.hrefid != result[1]) {
					oParagraph.hrefid = oParagraph.hrefid + "<BR>\n" + result[1];
				}
				//段名の設定
				switch(LineType) {
				case "genbun":
					oParagraph.title = result[2]+"";
					break;
				case "roman":
					oParagraph.title2 = result[2]+"";
					break;
				default:
					if(oParagraph.title=="") {
						oParagraph.title = result[2]+"";
					}
					break;
				}
			}
			else {
				oParagraph = null;
			}
		}
		else if(oParagraph) {
			if(result=/<A name="?in([0-9]*)"?>【(出典|校訂)】/i.exec(htmlLine)) {
				//出典・校訂のアンカー⇒無視
				//章 = null;
				//段 = null;
			}
			else if(result=/<A name="?(no[0-9]*)"?>(出典[0-9]*)<\/A>　*(.*)<A href="#(te[0-9]*)">（戻）<\/A>/i.exec(htmlLine)) {
				//出典の記述を抽出
				var hrefid = result[1];
				var src = oVolume.Sources[hrefid];
				if(src==null) {
					src = oVolume.Sources[hrefid] = new Source(hrefid, "", "", null, -1);
				}
				src.idname  = result[2];
				src.comment = result[3].replace(/([^（）]+（[^（）]+）( *<BR>[　 ]*)?)/ig, "；$1")
				                       .replace(/^；(.*)$/, "$1");
				src.source  = "";
				src.author  = "";
				src.retHref = result[4];
				var sources = src.comment.split("；");
				if(sources.length>0) {
					var ix;
					for(ix=0; ix<sources.length; ++ix) {
						if(result=/^([^（）]+)（([^（）]+)）/.exec(sources[ix])) {
							src.source = src.source + "<HR>" + result[1];
							src.author = src.author + "<HR>" + result[2];
						}
					}
					src.source = src.source.slice(4);
					src.author = src.author.slice(4);
				}
			}
			else if(result=/<A name="?(k[0-9]*)"?>(校訂[0-9]*)<\/A>　*(.*)<A( href="#)(te?[0-9]*)">(（戻）|戻る)<\/A>/i.exec(htmlLine)) {
				//校訂の記述を抽出
				var hrefid = result[1];
				var rev = oVolume.Revises[hrefid];
				if(rev==null) {
					rev = oVolume.Revises[hrefid] = new Revise(hrefid, "", "", null, -1);
				}
				rev.idname  = result[2];
				rev.comment = result[3];
				rev.retHref = result[5];
			}
			else if(result=/(?:備考--|【校訂方針】).*<BR>/i.exec(htmlLine)) {
				//校訂の凡例や校訂方針⇒無視
			}
			else if(result=/<A href="[a-zA-Z0-9]*\.html">(.*)<\/A><BR>/i.exec(htmlLine)) {
				//関連ページへのリンク⇒無視
				oChapter = null;
				oParagraph = null;
			}
			else if(LineType=="notes") {
				if(result=/【([^【】]*)】－ *(.*)<BR>/i.exec(htmlLine)) {
					//注釈の記述を抽出
					oVolume.notenocnt = oVolume.notenocnt + 1;
					oParagraph.notes[oParagraph.notes.length] = new Note(oVolume.notenocnt, result[1], result[2]);
				}
			}
			else if(result=/<IMG src="([^""]*)"/i.exec(htmlLine)) {
				//絵へのリンクを抽出
				oParagraph.images[oParagraph[LineType].length] = result[1];
			}
			else {
				//行の内容を変換して登録する。
				var lineno = oParagraph[LineType].length;//段内LineNo
				var lineid = oParagraph.id+"."+(lineno+1);//行ＩＤを採番
				switch(LineType) {
					case "genbun": {
						if(result=/(<A href="#no)([0-9]+)">/i.exec(htmlLine)) {
							//出典へのリンクを抽出
							var hrefs = htmlLine.split(result[1]);
							for(hrefno=0;hrefno<hrefs.length;++hrefno) {
								var href = hrefs[hrefno];
								if(result=/^([0-9]*)[""]>([^<>]*)(<\/A>|<BR>)?/i.exec(href)) {
									var sourceid = "no" + result[1];
									oParagraph.sources[oParagraph.sources.length] = sourceid;
									oVolume.Sources[sourceid] = new Source(sourceid, lineid, result[2], oParagraph[LineType], lineno);
									if(result[3]!="</A>") {
										splitPos = result[0].length - (result[3]=="<BR>"? 4 : 0);
										restLine = hrefs[hrefno].slice(splitPos);
										hrefs[hrefno] = hrefs[hrefno].slice(0, splitPos)+"</A>"+restLine;
										if(result[3]=="<BR>") {
											if(result=/^(　*)([^<>]*)<\/A>/i.exec(htmlLines[line+1])) {
												oVolume.Sources[sourceid].keyword = oVolume.Sources[sourceid].keyword + result[2];
												htmlLines[line+1] = htmlLines[line+1].replace(/^([^<>]*)<\/A>/i, "$1");
											}
										}
										else {
											if(result=/<\/A>( *)<\/A>/i.exec(hrefs[hrefno])) {
												hrefs[hrefno] = hrefs[hrefno].replace(/<\/A> *<\/A>/ig, "<\/A>");
											}
										}
									}
								}
							}
							htmlLine = hrefs.join("<A class=linkShutten href=\"#no");
						}
						if(result=/(<A href="#k)([0-9]+)">/i.exec(htmlLine)) {
							//校訂へのリンクを抽出
							var hrefs = htmlLine.split(result[1]);
							for(hrefno=0;hrefno<hrefs.length;++hrefno) {
								var href = hrefs[hrefno];
								if(result=/^([0-9]*)[""]>([^<>]*)(<\/A>)?/i.exec(href)) {
									var reviseid = "k" + result[1];
									oParagraph.revises[oParagraph.revises.length] = reviseid;
									oVolume.Revises[reviseid] = new Revise(reviseid, lineid, result[2], oParagraph[LineType], lineno);
									if(result[3]!="</A>") {
										hrefs[hrefno] = hrefs[hrefno].slice(0, result[0].length)+hrefs[hrefno].slice(result[0].length)
									}
								}
							}
							htmlLine = hrefs.join("<A class=linkKoutei href=\"#k");
						}
						{// 注釈へのリンクを挿入
							var reDelTagsOrDelims = /([、。「」『』▼★　 ]+|<[^<>]*>)/ig
							var noTagsOrDelems = htmlLine.replace(reDelTagsOrDelims, "");
							oVolume.cntLines++;
							if(noTagsOrDelems!="") {
								var lineAppend = "";
								var cnt = 0;
								var lastlineno = 0;
								var unmatchedCount = 0;
								var reDelSpace = /[ ]/g;
								var reDelDelims = /[　、。「」『』▼★ ]/g;
								for (i = 0; i < oParagraph.notes.length;i++) {
									var note = oParagraph.notes[i];
									// if(note.noteno==168) stop
									if(note.lineid == null            || /*リンク未設定*/
									   note.refLineno < lastlineno &&    /*リンクを誤認設定している可能性大*/
									   lineno         >=lastlineno     )
									{
										var keywords = note.keyword.split("--");
										var kw;
										note.pos = -1;
										for(kw=0;kw<keywords.length;++kw) {
											var keyword = keywords[kw].replace(reDelSpace, "");
											var keywordNoDelims = keyword.replace(reDelDelims, "");
											var found = 0;
											var pos = -1;
											if(htmlLine.indexOf(keyword)>=0) {
												htmlLine = htmlLine.split(keyword).join(
													"<A class=linkNote href=\"#note"+note.noteno
													              +"\">"+keyword+"</A>");
												//found = (keywords.length==1? 1: 2);
												if(kw==0) {
													found=1;
													pos = noTagsOrDelems.indexOf(keywordNoDelims);
												}
												else {
													found=2;
												}
											}
											else if(pos=noTagsOrDelems.indexOf(keywordNoDelims), pos>=0)
											{
												htmlLine = htmlLine.replace(/<\/A>([^<>]*)<\/A>/ig, "</A>$1");
												var reMatchIgnoreDelims = new RegExp("("+keywordNoDelims.split("").join("[、。　「」『』]*")+")");
												var noteAppend = "";
												while(result = reMatchIgnoreDelims.exec(htmlLine), result==null) {
													//注釈と出典・校訂が競合している場合の処理
													var prevLastIndex = 0;
													var newHtmlLine = "";
													var reLink = /(<A class=link(Koutei|Shutten) href=[^<>]*>)([^<>]*)(<\/A>)/ig;
													while(result2=reLink.exec(htmlLine), result2) {
														var kw2NoDelims = result2[3].replace(reDelDelims,"");
														if(kw2NoDelims.length>0 && keywordNoDelims.indexOf(kw2NoDelims)>=0) {
															//出典・校訂が注釈の内部に含まれる。
															newHtmlLine = newHtmlLine + htmlLine.substring(prevLastIndex, result2.index) + result2[3];
															prevLastIndex = result2.lastIndex;
															noteAppend = noteAppend + result2[1] + "★" + result2[4];
														}
													}
													if(prevLastIndex<=0) break;
													htmlLine = newHtmlLine + htmlLine.substr(prevLastIndex);
												}
												if(result) {
													//出典・校訂が注釈の内部に含まれる。
													htmlLine = htmlLine.replace(result[0], 
														"<A class=linkNote href=\"#note"+note.noteno
														              +"\">"+result[0]+"</A>"+noteAppend);
													if(kw==0) {
														found=1;
													}
													else {
														found=2;
													}
												}
												else {
													var reMatchIgnoreTagsOrDelims = new RegExp("("+keywordNoDelims.split("").join("([、。「」『』▼★　 ]+|<[^<>]*>)*")+")");
													if( (result = reMatchIgnoreTagsOrDelims.exec(htmlLine)) &&
														(result2=/^([^　 <]+)(<A .*)$/i.exec(result[0]), result2)  )
													{
														//注釈の末尾と出典・校訂の先頭が重なる。包含関係には無い。
														htmlLine = htmlLine.replace(result[0], 
															"<A class=linkNote href=\"#note"+note.noteno
															              +"\">"+result2[1]+"</A>"+noteAppend+result2[2]);
														found=2;
													}
													else if( result &&
													        (result2=/^([^　 <]+)<\/A>([^<>]*)((<.*)?)$/i.exec(result[0]), result2)  )
													{
														//出典・校訂の末尾と注釈の先頭が重なる。包含関係には無い。
														htmlLine = htmlLine.replace(result[0], 
															"</A> <A class=linkNote href=\"#note"+note.noteno
															              +"\">"+result2[1]+result2[2]+"</A>"+noteAppend+result2[3]);
														if(kw==0) {
															found=1;
														}
														else {
															found=2;
														}
													}
													else {
														//debug.debug();
														lineAppend = lineAppend + noteAppend +
															"<A class=linkNote href=\"#note"+note.noteno
															              +"\">★</A>";
														found = 3;
													}
												}
											}
											else if(keywordNoDelims.indexOf(noTagsOrDelems)>=0  )
											{
												if(htmlLine.indexOf(noTagsOrDelems)>=0) {
													htmlLine = htmlLine.split(noTagsOrDelems).join(
														"<A class=linkNote href=\"#note"+note.noteno
														              +"\">"+noTagsOrDelems+"</A>");
													found = 2;
												}
												else {
													htmlLine = "<A class=linkNote href=\"#note"+note.noteno
														              +"\">"+htmlLine+"</A>";
													found = 2;
												}
											}
											if( found!=0) {
												if(note.lineid &&
												   note.refLineno < lineno)
												{
													//誤認設定したリンクを削除
													//debug.debug();
													note.refLines[note.refLineno] = note.refLines[note.refLineno]
														.replace(new RegExp("<A class=linkNote href=\"#note"+note.noteno+"\">([^<>]*)<\\/A>")
														        , /*"<!--#badnote"+note.noteno+"-->"+*/ (note.found!=3? "$1" : "") );
												}
												note.found  = found;
												note.lineid = lineid;
												note.refLines  = oParagraph[LineType];
												note.refLineno = lineno;
												note.refPos = pos;
												note.unmatched = false;
												unmatchedCount = 0;
											}
											else {
												unmatchedCount++;
												if(unmatchedCount>=3) break;
											}
										}
									}
									if(note.refLineno> lastlineno)
									{
										lastlineno = note.refLineno;
									}
								}
							}
						}
						if(lineAppend!="") {
							htmlLine = htmlLine + lineAppend;
							lineAppend="";
						}
						break;
					}
					case "roman": { // 和歌を抽出
						if(result=/^((?:[　 ""'']|&nbsp;)*)<I>([^<>]+)<BR>((?:[　 ]|&nbsp;)*)([^<>]+[""'']?)<\/I>([""'']?)<BR>$/i.exec(htmlLine)) {
							var kaminoku  = result[1]+result[2]; //和歌（上の句）?
							var shimonoku = result[3]+result[4]; //和歌（下の句）
							htmlLine = "&nbsp;&nbsp;" + kaminoku  + "<BR>"
							         + "&nbsp;&nbsp;" + shimonoku + "<BR>";
							oParagraph.tankas[lineno] = new Tanka(lineid, oParagraph[LineType], lineno, 1);
						}
						else if(result=/^((?:[　 ""'']|&nbsp;)*)<I>([^<>]+)<BR>$/i.exec(htmlLine)) {
							var kaminoku = result[1]+result[2]; //和歌（上の句）?
							//myReportWriter.writeln("<HR>"+lineid+"<BR>上の句："+kaminoku);
							if(result=/^((?:[　 ]|&nbsp;)*)([^<>]+[""'']?)<\/I>([""'']?)<BR>$/i.exec(htmlLines[line+1])) {
								var shimonoku = result[1]+result[2]; //和歌（下の句）
								//myReportWriter.writeln("<BR>下の句："+shimonoku);
								htmlLine          = "&nbsp;&nbsp;" + kaminoku + "<BR>";
								htmlLines[line+1] = "&nbsp;&nbsp;" + shimonoku + "<BR>";
								oParagraph.tankas[lineno] = new Tanka(lineid, oParagraph[LineType], lineno, 2);
							}
						}
						break;
					}
				}
				oParagraph[LineType][lineno] = htmlLine;
			}
		}
		else {
			if(result=/<TITLE>(.*)<\/TITLE>/i.exec(htmlLine)) {
				//帖名の設定 tmpdirフォルダ内のファイルの<TITLE>行はMakeContents.htaで書式が書き換えられていることに注意。
				
				if(result=/^([0-9][0-9])(?:[ 　]|&nbsp;)+([^（）]*)(?:（(.*)）)?(?:[ 　]|&nbsp;)+(本文|現代語訳|注釈|与謝野晶子訳|Japanese roman letters)/.exec(result[1])) {
					switch(result[4]) {
					case "本文":
					case "現代語訳":
					case "注釈":
						var title      = "第"+ToChineseNumeral(result[1])+"帖 "+result[2];
						var sourceBook = result[3];
						if(oVolume.title && LineType!="genbun") {
							//if(title!=oVolume.title) stop; // 第21帖で乙女と少女が混在する。
						}
						else {
							oVolume.title = title;
						}
						if(sourceBook) {
							if(oVolume.sourceBook) {
								if(sourceBook!=oVolume.sourceBook) stop;
							}
							else {
								oVolume.sourceBook = sourceBook;
							}
						}
						break;
					case "与謝野晶子訳":
						if(!oVolume.title) stop;
						if(!oVolume.sourceBook) stop;
						break;
					case "Japanese roman letters":
						if(LineType!="roman") stop
						oVolume.title2 = result[1]+" "+result[2]+"";
					}
				}
				else if(LineType=="yosano") {
					if(!oVolume.title) stop;
					if(!oVolume.sourceBook) stop;
				}
				else stop;
				/*
				switch(LineType) {
				case "genbun":
					if(result=/^([0-9][0-9]) ([^（）]*)（(.*)）/.exec(result[1]+"")) {
						oVolume.title      = result[2]+"";
						oVolume.sourceBook = result[3]+"";
					}
					//docProgress.write(oVolume.title+"<br>\n");
					break;
				case "roman":
					oVolume.title2 = result[1]+"";
					break;
				default:
					if(oVolume.title=="") {
						oVolume.title = result[1]+"";
					}
					break;
				}
				*/
			}
			else if(result=/<P class=wakaAkiko>(.*)<BR>/i.exec(htmlLine)) {
				oVolume.wakaAkiko = result[1];
				//alert(oVolume.wakaAkiko);
			}
			else if(result=/<H3>(.*)<\/H3>/i.exec(htmlLine)) {
				lastH3 = line;
				//帖名-2の設定
				switch(LineType) {
				case "genbun":
					oVolume.h3 = result[1]+"";
					break;
				case "roman":
					oVolume.h3_2 = result[1]+"";
					break;
				default:
					if(oVolume.h3=="") {
						oVolume.h3 = result[1]+"";
					}
					break;
				}
			}
			else if(result=/(<ADDRESS>.*<\/ADDRESS>)/i.exec(htmlLine)) {
				//著作権表示先頭
				oVolume["address_"+LineType] = oVolume["address_"+LineType] + result[1];
				address = true;
			}
			else if(result=/(<ADDRESS>[^<>]*<BR>)/i.exec(htmlLine)) {
				//著作権表示先頭
				oVolume["address_"+LineType] = oVolume["address_"+LineType] + result[1];
				address = true;
			}
			else if(result=/([^<>]*<\/ADDRESS>)/i.exec(htmlLine)) {
				//著作権表示末尾
				oVolume["address_"+LineType] = oVolume["address_"+LineType] + result[1];
				address = false;
			}
			else if(result=/<DT>[　]*([^<>&;]*)(?:<|&lt;)([^<>]*)(?:&gt;|>) *(:?<BR>|$)/i.exec(htmlLine)) {
				//登場人物
				currPerson = oVolume.AppearedPeople[oVolume.AppearedPeople.length] = new Person(result[1], result[2]);
			}
			else if(result=/<DD>呼称---([^、]*)、(.*)<BR>/i.exec(htmlLine)) {
				currPerson.koshou = result[1].split("・");
				currPerson.title = result[2].split(/[、　]/);
			}
			else if(result=/<DD>呼称---(.*)<BR>/i.exec(htmlLine)) {
				currPerson.koshou = result[1].split("・");
			}
			else if(result=/<A (?:HREF|href)="#in([0-9]*)">(.*)<\/A>/i.exec(htmlLine)) {
				var id = result[1];
				oVolume["intro_"+LineType][id] = new Intro(id, result[2]);
			}
			else if(address) {
				//著作権表示
				if(result=/Eiri Genji Monogatari/i.exec(htmlLine)) {
					oVolume["address_image"] = htmlLine;
				}
				else {
					oVolume["address_"+LineType] = oVolume["address_"+LineType] + htmlLine;
				}
			}
			else if(line==lastH3+1 && LineType!="notes") {
				if(result=/^[ 　]*(.*)<BR>/i.exec(htmlLine)) {
					//副題の設定
					if(result[1]!="[主要登場人物]") {
						switch(LineType) {
						case "genbun":
							oVolume.subtitle = result[1]+"";
							break;
						case "roman":
							oVolume.subtitle2 = result[1]+"";
							break;
						default:
							if(oVolume.subtitle=="") {
								oVolume.subtitle = result[1]+"";
							}
							break;
						}
					}
				}
			}
		}
	}
	if(LineType=="romanXXX") {
		//ローマ字版からひらがな版を作成し、ルビを付加する。
		for(ChapterNo=0; ChapterNo<oVolume.Chapters.length; ++ChapterNo)
		{
			oChapter = oVolume.Chapters[ChapterNo];
			if(oChapter)
			{
				for(ParagraphNo=0; ParagraphNo < oChapter.Paragraphs.length; ++ParagraphNo)
				{
					oParagraph = oChapter.Paragraphs[ParagraphNo];
					if(oParagraph) {
						var genbunLines   = oParagraph["genbun"];
						var romanLines    = oParagraph["roman"];
						var hiraganaLines = oParagraph["hiragana"];
						for(lineno=0;lineno<romanLines.length;++lineno) {
							//ローマ字版からひらがな版を作成する。
							hiraganaLines[lineno] = cvRoman2Hiragana(chk(romanLines[lineno]));
							//ルビ付加
							genbunLines[lineno] = addRuby(chk(genbunLines[lineno]), chk(hiraganaLines[lineno]));
						}
					}
				}
			}
		}
	}
	if(LineType=="genbun") {
		for(ChapterNo=0; ChapterNo<oVolume.Chapters.length; ++ChapterNo)
		{
			oChapter = oVolume.Chapters[ChapterNo];
			if(oChapter)
			{
				for(ParagraphNo=0; ParagraphNo < oChapter.Paragraphs.length; ++ParagraphNo)
				{
					oParagraph = oChapter.Paragraphs[ParagraphNo];
					if(oParagraph) {

						//本文と一致しなかった注釈を前後の注釈との位置関係に基づいて対応させる。
						var i;
						var lastlineno = -1;
						var unmatchedNote = -1;
						for(i=0; i < oParagraph.notes.length; ++i)
						{
							var note = oParagraph.notes[i];
							if(note.refLines) {
								if(unmatchedNote>=0 &&
								   note.refLineno == lastlineno)
								{
									for(j=unmatchedNote; j<i; ++j) {
										var unmatched = oParagraph.notes[j];
										if(unmatched.refLines==null) {
											unmatched.found     = 4;
											unmatched.lineid    = note.lineid;
											unmatched.refLines  = note.refLines;
											unmatched.refLineno = note.refLineno;
											unmatched.refLines[unmatched.refLineno] = 
											unmatched.refLines[unmatched.refLineno] +
												"<A class=linkNote href=\"#note"+unmatched.noteno
												              +"\">☆</A>";
										}
									}
								}
								lastlineno = note.refLineno;
								unmatchedNote = -1;
							}
							else if(unmatchedNote<0) {
								unmatchedNote = i;
							}
						}

						var lines = oParagraph[LineType] .length;
						for(lineno=0;lineno<lines;++lineno) {
							htmlLine = oParagraph[LineType][lineno];

							//リンクの入れ子対策
							htmlLine = htmlLine.replace(/(<A [^<>]*>) *(<A [^<>]*>)/ig, "$1▼$2");
							htmlLine = htmlLine.replace(/(<A [^<>]*>)([^<>]*)(<A [^<>]*>)/ig, "$1$2</A> $3");
							htmlLine = htmlLine.replace(/<\/A>([^<>]*)<\/A>/ig, "</A>$1");

							oParagraph[LineType][lineno] = htmlLine;
						}

					}
				}
			}
		}
		//注釈・出典・校訂のリンク上でマウスを止めたとき内容がツールチップで表示されるようにする。(titleプロパティの挿入)
		for(ChapterNo=0; ChapterNo<oVolume.Chapters.length; ++ChapterNo)
		{
			oChapter = oVolume.Chapters[ChapterNo];
			if(oChapter)
			{
				for(ParagraphNo=0; ParagraphNo < oChapter.Paragraphs.length; ++ParagraphNo)
				{
					oParagraph = oChapter.Paragraphs[ParagraphNo];
					if(oParagraph) {
						var i;
						for(i=0; i < oParagraph.notes.length; ++i)
						{
							var note = oParagraph.notes[i];
							if(note.refLines) {
								//注釈のリンク上でマウスを止めたとき内容がツールチップで表示されるようにする。(titleプロパティの挿入)
								var strTitle = note.comment.replace(/\"/g, "\\\"").replace(/<BR>/ig,"");
								if(note.found>=2) {
									strTitle = "【" + note.keyword + "】－" +strTitle
								}
								var anchorTag = "<A class=linkNote href=\"#note"+note.noteno+"\"";
								note.refLines[note.refLineno] = note.refLines[note.refLineno].split(anchorTag).join(" "+anchorTag+" title=\""+strTitle+"\"");
							}
						}
						for(i=0; i < oParagraph.sources.length; ++i)
						{
							var src = oVolume.Sources[oParagraph.sources[i]];
							if(src.refLines) {
								//出典のリンク上でマウスを止めたとき内容がツールチップで表示されるようにする。(titleプロパティの挿入)
								var comment = src.comment.replace(/<\/?R[PTUBY]*>/ig,"").replace(/<BR>/ig,"");
								var anchorTag = "<A class=linkShutten href=\"#"+src.hrefid+"\"";
								src.refLines[src.refLineno] = src.refLines[src.refLineno].split(anchorTag).join(" "+anchorTag+" title=\""+src.idname+"【"+ src.keyword + "】－"+comment+"\"");
							}
						}
						for(i=0; i < oParagraph.revises.length; ++i)
						{
							var rev = oVolume.Revises[oParagraph.revises[i]];
							if(rev.refLines) {
								//校訂のリンク上でマウスを止めたとき内容がツールチップで表示されるようにする。(titleプロパティの挿入)
								var anchorTag = "<A class=linkKoutei href=\"#"+rev.hrefid+"\"";
								rev.refLines[rev.refLineno] = rev.refLines[rev.refLineno].split(anchorTag).join(" "+anchorTag+" title=\""+rev.idname+"："+rev.comment+"\"");
							}
						}
					}
				}
			}
		}
	}
}

function GenjiParser(id)
{
	docProgress.write("第" + id + "帖 読込み開始<br>\n");

	oVolume = new Book(id);

	parseGenjiBook(oVolume, indir+"version" +id+".html", "yakubun");
	parseGenjiBook(oVolume, indir+"note"    +id+".html",   "notes");
	parseGenjiBook(oVolume, indir+"text"    +id+".html",  "genbun");
	parseGenjiBook(oVolume, indir+"roman"   +id+".html",   "roman");
	var yosanoFilename = yosanodir+"yosano" +id+".html";
	if(fso.FileExists(yosanoFilename)) {
		oVolume.flgTransYosano=true;
		parseGenjiBook(oVolume, yosanoFilename,  "yosano");
	}

	if(oVolume.title=="" && oVolume.h3) {
		stop
		oVolume.title = oVolume.h3;
	}
	if(oVolume.title2=="" && oVolume.h3_2) {
		stop
		oVolume.title2 = oVolume.h3_2;
	}

	return oVolume;
}

function chk(str)
{
	if(str==null||str=="undefined") {
		return "";
	}
	else {
		return str;
	}
}

function getCombinedHtml(oVolume)
{
	docProgress.write(oVolume.title + " HTML版出力開始<br>\n")
	
	var no = oVolume.id;

	var template = ReadWholeFile("template.Combined.html")
		.replace(/<%=address%>/g, address)
		.replace(/<%=title1%>/g, oVolume.title /*+"（"+oVolume.sourceBook+"）"*/ )
		.replace(/<%=title2%>/g, oVolume.title2)
		.replace(/<%=no%>/g, no)
		.split("<%=title%>");
	var bookTop = template[0];
		template = template[1].split("<%=body%>");
	var bookHead = template[0];
	var bookTail = template[1];

	var writer = new MyStringWriter();

	var original = "http://www.sainet.or.jp/~eshibuya/";
	var yosano   = "http://www.genji.co.jp/yosano/";

	var title=oVolume.title;

	if(oVolume.subtitle!="" && oVolume.subtitle!=oVolume.Chapters[0].title) {
		var subtitle1=oVolume.subtitle;
		if(result=/^(.*時代)([一二三四五六七八九]*十[一二三四五六七八九]*歳.*)$/.exec(subtitle1),result) {
			subtitle1 = result[1] + "<br>" + result[2];
		}
		writer.write("<TR class=trSubTitle>\n");
		writer.write("<TD>                                     <SPAN class=cIdno></SPAN></TD>\n");
		writer.write("<TD align=center valign=middle colspan=3><B class=cTitle> <BR><FONT size=6>"+subtitle1 +"</FONT><BR><BR></B></TD>\n");
		writer.write("<TD align=center valign=middle>          <B class=cRoman> <BR><FONT size=6>"+oVolume.subtitle2+"</FONT><BR><BR></B></TD>\n");
		writer.write("</TR>\n");
	}

	if(!oVolume.flgTransYosano) {
		writer.write("<SCRIPT>\n"
		            +"thchkYosano.style.display='none';\n"
		            +"tdchkYosano.style.display='none';\n"
		            +"</SCRIPT>\n");
	}
	
	bookHead = bookHead + writer.string;
	
	writer.clear();
	writer.write("<TR class=trAddr>\n");
	writer.write("<TD><SPAN class=cIdno></SPAN></TD>\n");
	writer.write("<TD align=center valign=middle nowrap>"
	            +"<SPAN class=cGenbun> <A href=\""+original+"text"   +no+".html\" target=text>"   +oVolume["address_genbun"] +"</A>"
	            +"<SPAN class=cNotes>  <A href=\""+original+"note"   +no+".html\" target=note>"   +oVolume["address_notes"]  +"</A></SPAN></SPAN></TD>\n");
	writer.write("<TD align=center valign=middle nowrap>"
	            +"<SPAN class=cYakubun><A href=\""+original+"version"+no+".html\" target=version>"+oVolume["address_yakubun"]+"</A></SPAN></TD>\n");
	writer.write("<TD align=center valign=middle nowrap style='padding:8'>"+(oVolume.flgTransYosano ?
	             "<SPAN class=cYosano>"+Copyright4TransYosano[no*1].Copyright+"</SPAN>":"")+"</TD>\n");
	writer.write("<TD align=center valign=middle nowrap>"
	            +"<SPAN class=cRoman>  <A href=\""+original+"roman"  +no+".html\" target=roman>"  +oVolume["address_roman"].replace(" by ","<br>by ")+"</A></SPAN></TD>\n");
	writer.write("</TR>\n");
	writer.write("<TR class=trAddr>\n");
	writer.write("<TD>                                            <SPAN class=cIdno></SPAN></TD>\n");
	writer.write("<TD colspan=4 align=center valign=middle nowrap><SPAN class=cImage> "+oVolume["address_image"]  +"</SPAN></TD>\n");
	writer.write("</TR>\n");
	
	bookTail = writer.string + bookTail;
	
	var fpBook = null;
	if(bToCreateFileEveryBook==true) {
		var bookFileName = OutputHtmlFileNames["combined帖全体"].replace(/##/g, no) + ".html";
		CreateParentFolder(bookFileName);
		fpBook = new MyStreamWriter(bookFileName);
		fpBook.write(bookTop);
		fpBook.write(title);
		fpBook.write(bookHead);
	}

	for(noChapter=0;noChapter<oVolume.Chapters.length;++noChapter) {
		writer.clear();
		var oChapter = oVolume.Chapters[noChapter];
		docProgress.write(title + " " + oChapter.title + "<br>\n")
		writer.write("<TR class=trChapterTitle>\n");
		writer.write("<TD              valign=middle nowrap><A class=cIdno href=\"#chapter"+oChapter.id+"\">"+oChapter.id+"</A></TD>\n");
		writer.write("<TD align=center valign=middle nowrap colspan=3><A name=\"chapter"+oChapter.id+"\"></A><B class=cTitle><BR><FONT size=5>"+oChapter.title +"</FONT><BR><BR></B></TD>\n");
		writer.write("<TD>                                            <B class=cRoman><BR><FONT size=5>"+oChapter.title2+"</FONT><BR><BR></B></TD>\n");
		writer.write("<TD><SPAN class=cLinks id=\"span.chapter"+oChapter.id+"\"></SPAN></TD>\n");
		writer.write("</TR>\n");
		
		var chapterHead = writer.string;

		var fpChapter = null;
		if(bToCreateFileEveryChapter==true) {
			var chapterFileName = OutputHtmlFileNames["combined章単位"].replace(/##/g, no)+"."+(noChapter+1)+".html";
			CreateParentFolder(chapterFileName);
			fpChapter = new MyStreamWriter(chapterFileName);
			fpChapter.write(bookTop);
			fpChapter.write(title+ "　" + oChapter.title);
			fpChapter.write(bookHead);
			fpChapter.write(chapterHead);
		}
		if(fpBook) {
			fpBook.write(chapterHead);
		}
		
		for(noParagraph=0;noParagraph < oChapter.Paragraphs.length;++noParagraph) {
			writer.clear();
			var oParagraph = oChapter.Paragraphs[noParagraph];
			//docProgress.write(title+ "　" + oChapter.title + "　" + oParagraph.title + "<br>\n")
			writer.write("<TR class=trParagraphTitle>\n");
			writer.write("<TD              valign=middle nowrap><A class=cIdno href=\"#paragraph"+oParagraph.id+"\">"+oParagraph.id+"</A></TD>\n");
			writer.write("<TD align=center valign=middle nowrap colspan=3><A name=\"paragraph"+oParagraph.id+"\"></A><B class=cTitle><BR><FONT size=4>"+oParagraph.title +"</FONT><BR><BR></B></TD>\n");
			writer.write("<TD align=center valign=middle>                 <B class=cRoman><BR><FONT size=4>"+oParagraph.title2+"</FONT><BR><BR></B></TD>\n");
			writer.write("<TD><SPAN class=cLinks id=\"span.paragraph"+oParagraph.id+"\"></SPAN></TD>\n");
			writer.write("</TR>\n");
			var lines = oParagraph["genbun"] .length;
			if(	lines != oParagraph["yakubun"].length ||
				lines != oParagraph["roman"]  .length ||
				lines != oParagraph["yosano"] .length ||
				lines != oParagraph["roman"]  .length  ) {
				var msg = no+"."+oParagraph.id+"段の行数不一致 "+lines+"："+oParagraph["yakubun"].length+"："+oParagraph["yosano"].length+"："+oParagraph["roman"].length;
				if( ! ConfirmedLineCountMismatches[msg]) {
					myReportWriter.writeln(msg+"<BR>");
				}
				if( lines < oParagraph["yakubun"].length) lines = oParagraph["yakubun"].length;
				if( lines < oParagraph["roman"]  .length) lines = oParagraph["roman"]  .length;
				if( lines < oParagraph["yosano"] .length) lines = oParagraph["yosano"] .length;
			}
			for(line=0;line<lines;++line) {
				if(line < oParagraph.images.length && oParagraph.images[line]) {
					//挿絵
					writer.write("<TR class=trImage>\n");
					writer.write("<TD><SPAN class=cIdno></SPAN></TD>\n");
					writer.write("<TD colspan=4 align=center valign=middle><IMG src=\""+imgdir+oParagraph.images[line]+"\"></TD>\n");
					writer.write("</TR>\n");
				}
				var lineid = oParagraph.id+"."+(line+1);
				var tanka = oParagraph.tankas[line];
				if(tanka && !tanka.done) {
					if(tanka.lines == 1) {
						//和歌 (上の句 & 下の句)
						oParagraph["genbun"] [line] = cvTanka1("Genbun",  oParagraph["genbun"] [line], tanka);
						oParagraph["yakubun"][line] = cvTanka1("Yakubun", oParagraph["yakubun"][line], tanka);
						oParagraph["roman"]  [line] = cvTanka1("Roman",   oParagraph["roman"]  [line], tanka);
						tanka.done = true;
					}
					else if(tanka.lines == 2) {
						//和歌の上の句
						oParagraph["genbun"] [line] = cvTanka("cKaminokuGenbun",  oParagraph["genbun"] [line], tanka);
						oParagraph["yakubun"][line] = cvTanka("cKaminokuYakubun", oParagraph["yakubun"][line], tanka);
						oParagraph["roman"]  [line] = cvTanka("cKaminokuRoman",   oParagraph["roman"]  [line], tanka);
					}
					else stop
				}
				else {
					tanka = oParagraph.tankas[line-1];
					if(tanka && !tanka.done) {
						if(tanka.lines != 2) stop
						//和歌の下の句
						oParagraph["genbun"] [line] = cvTanka("cShimonokuGenbun",  oParagraph["genbun"] [line], tanka);
						oParagraph["yakubun"][line] = cvTanka("cShimonokuYakubun", oParagraph["yakubun"][line], tanka);
						oParagraph["roman"]  [line] = cvTanka("cShimonokuRoman",   oParagraph["roman"]  [line], tanka);
						tanka.done = true;
					}
				}
				writer.write("<TR class=trHonbun>\n");
				writer.write("<TD nowrap><A class=cIdno href=\"#line"+lineid+"\">"+lineid+"</A></TD>\n");
				writer.write("<TD><SPAN class=cGenbun><A name=\"line"+lineid+"\"></A>"+chk(oParagraph["genbun"] [line])+"</SPAN></TD>\n");
				writer.write("<TD><SPAN class=cYakubun>"                              +chk(oParagraph["yakubun"][line])+"</SPAN></TD>\n");
				writer.write("<TD><SPAN class=cYosano>"                               +chk(oParagraph["yosano"] [line])+"</SPAN></TD>\n");
				writer.write("<TD><SPAN class=cRoman>"                                +chk(oParagraph["roman"]  [line])+"</SPAN></TD>\n");
				writer.write("<TD><SPAN class=cLinks id=\"span.line"+lineid+"\"></SPAN></TD>\n");
				writer.write("</TR>\n");
			}

			//注釈
			writer.write("<TR class=trNotes>\n");
			writer.write("<TD><SPAN class=cIdno></SPAN></TD>\n");
			writer.write("<TD colspan=3 align=center valign=middle>\n");
			writer.write("<BLOCKQUOTE>\n");
			writer.write("<TABLE class=noteTable id=tblNotes"+(noChapter+1)+"_"+(noParagraph+1)+" border=1 cellspacing=0 cellpadding=0>\n");
			var lastlineno = 0;
			var lastpos = -1;
			for(noteno=0; noteno < oParagraph.notes.length; ++noteno) {
				var note = oParagraph.notes[noteno];
				writer.write("<TR><TD class=noteNo nowrap>注釈"       + note.noteno
				           +"</TD><TD class=noteKeyword>"+ note.keyword
				           +"</TD><TD class=noteComment>"+ note.comment
				           +"</TD><TD class=noteReturn nowrap valign=top>"+(note.lineid==null ? "－":
				       "<A class=noteReturnLink name=\"note" + note.noteno+
				       "\" href=\"#line"+ note.lineid+
				                  "\">" + note.lineid+"</A>")
				                        +(note.found==3 ? "<BR>★" : 
				                          note.found==4 ? "<BR>☆" : 
				                          "")
				                        +"</TD></TR>\n");
				if(note.lineid==null || note.found>=3) {
					myReportWriter.writeln("注釈" + note.noteno + "【" + note.keyword + "】"+ (note.found==3?"★":
					                                                                        note.found==4?"☆":"")+"<BR>");
					oVolume.cntUnmatchedNote++;
					note.unmatched=true;
				}
				else if(note.refLineno < lastlineno ||
				        note.refLineno == lastlineno &&
				        note.refPos>=0 && lastpos>=0 &&
				        note.refPos < lastpos)
				{
					myReportWriter.writeln("注釈" + note.noteno + "【" + note.keyword + "】逆順<BR>");
					oVolume.cntUnmatchedNote++;
					note.unmatched=true;
				}
				if(lastlineno < note.refLineno ) {
					lastlineno = note.refLineno;
					lastpos = note.refPos;
				}
				else if(note.refLineno == lastlineno &&
				        note.pos>=0 && lastpos>=0 &&
				        note.pos > lastpos)
				{
					lastpos = note.refPos;
				}
			}
			writer.write("</TABLE>\n");
			writer.write("</BLOCKQUOTE></TD></TR>\n");

			//出典
			writer.write("<TR class=trSource>\n");
			writer.write("<TD><SPAN class=cIdno></SPAN></TD>\n");
			writer.write("<TD colspan=3 align=center valign=middle>\n");
			writer.write("<TABLE class=srcTable id=tblSource border=1 cellspacing=0 cellpadding=0>\n");
			for(srcno=0; srcno < oParagraph.sources.length; ++srcno) {
				var source = oVolume.Sources[oParagraph.sources[srcno]];
				var sources = source.source.split("<HR>");
				var authors = source.author.split("<HR>");
				var row;
				for(row=0; row<sources.length; ++row) {
					writer.write("<TR>\n");
					if(row==0) {
						writer.write("<TD rowspan="+sources.length+" class=srcNo nowrap>"+source.idname+"</TD>\n");
						writer.write("<TD rowspan="+sources.length+" class=srcKeyword>"+source.keyword+"</TD>\n");
					}
					writer.write("<TD class=srcSource>" +sources[row]+"</TD>\n");
					writer.write("<TD class=srcAuthor>" +authors[row]+"</TD>\n");
					if(row==0) {
						writer.write("<TD rowspan="+sources.length+" nowrap valign=top><A class=srcReturnLink name=\""+source.hrefid+"\""
						              +(source.lineid==""?"":" href=\"#line"+source.lineid)+"\">"+source.lineid+"<\/A>"+"</TD>\n");
					}
					writer.write("</TR>\n");
				}
			}
			writer.write("</TABLE>\n");
			writer.write("</TD></TR>\n");

			//校訂
			writer.write("<TR class=trRevise>\n");
			writer.write("<TD><SPAN class=cIdno></SPAN></TD>\n");
			writer.write("<TD colspan=3 align=center valign=middle>\n");
			writer.write("<TABLE class=revTable id=tblRevise border=1 cellspacing=0 cellpadding=0>\n");
			for(reviseno=0; reviseno < oParagraph.revises.length; ++reviseno) {
				var revise = oVolume.Revises[oParagraph.revises[reviseno]];
				writer.write("<TR>\n");
				writer.write("<TD class=revNo nowrap>"+revise.idname+"</TD>\n");
				writer.write("<TD class=revKeyword>"+revise.keyword+"</TD>\n");
				writer.write("<TD class=revComment>"+revise.comment+"</TD>\n");
				writer.write("<TD class=revReturn nowrap valign=top><A class=revReturnLink name=\""+revise.hrefid+"\""
				              +(revise.lineid==""?"":" href=\"#line"+revise.lineid)+"\">"+revise.lineid+"<\/A>"+"</TD>\n");
				writer.write("</TR>\n");
			}
			writer.write("</TABLE>\n");
			writer.write("</TD></TR>\n");
			
			if(bToCreateFileEveryParagraph==true) {
				var paragraphFileName = OutputHtmlFileNames["combined段単位"].replace(/##/g, no)+"."+(noChapter+1)+"."+(noParagraph+1)+".html";
				CreateParentFolder(paragraphFileName);
				var fpParagraph = new MyStreamWriter(paragraphFileName);
				fpParagraph.write(bookTop);
				fpParagraph.write(title+ "　" + oChapter.title + "　" + oParagraph.title);
				fpParagraph.write(bookHead);
				fpParagraph.write(chapterHead);
				fpParagraph.write(writer.string);
				fpParagraph.write(bookTail.replace(/<%=level%>/g, "Paragraph"));
				fpParagraph.Close();
			}
			if(fpChapter) {
				fpChapter.write(writer.string);
			}
			if(fpBook) {
				fpBook.write(writer.string);
			}
		}
		if(fpChapter) {
			fpChapter.write(bookTail.replace(/<%=level%>/g, "oChapter"));
			fpChapter.Close();
		}
	}
	if(fpBook) {
		fpBook.write(bookTail.replace(/<%=level%>/g, "Book"));
		fpBook.Close();
	}
}

function getIndexHtml(oVolume, filelevel)
{
	docProgress.write(oVolume.title + " 細目次<br>\n")

	var writer = new MyStringWriter();
	var writerTanka = new MyStringWriter();
	var writerImage = new MyStringWriter();
	var no = oVolume.id;
	//var filelevel = 3;
	//if(bToCreateFileEveryParagraph==true) filelevel = 2;
	//else if(bToCreateFileEveryChapter==true) filelevel = 1;
	//else if(bToCreateFileEveryBook==true) filelevel = 0;

	var fileid = new Array(3);
	fileid[0]=no;
	fileid[1]=no+".1";
	fileid[2]=no+".1.1";
	fileid[3]=no;
	filename="combined"+fileid[filelevel]+".html"

	var template = ReadWholeFile("template.Index.html")
	                            .replace(/<%=address%>/g, address)
	                            .split("<%####%>");

	writer.write(template[0]
		.replace(/<%=filename%>/g, filename)
		.replace(/<%=no%>/g, no)
		.replace(/<%=link2yosano%>/g, Copyright4TransYosano[no*1].href)
		.replace(/<%=title%>/g, oVolume.title)
		.replace(/<%=title1%>/g, oVolume.title /*+"（"+oVolume.sourceBook+"）"*/ )
		.replace(/<%=subtitle%>/g, oVolume.subtitle));
	writer.write("<TABLE id=tblPerson border=1 cellspacing=0 cellpadding=0 align=center>\n");
	writer.write("<TR><TH colspan=4><FONT size=+2>この帖の主な登場人物</FONT></TH></TR>\n");
	writer.write("<TR><TH>登場人物</TH><TH>読み</TH><TH>呼称</TH><TH>備考</TH></TR>\n");
	for(personno=0;personno<oVolume.AppearedPeople.length; ++personno) {
		writer.write("<TR>\n");
		writer.write("<TH align=center valign=middle nowrap>"+oVolume.AppearedPeople[personno].name+"</TH>\n");
		writer.write("<TD align=center valign=middle nowrap>"+oVolume.AppearedPeople[personno].yomi+"</TD>\n");
		writer.write("<TD align=left valign=middle nowrap>"+oVolume.AppearedPeople[personno].koshou.join("<BR>\n")+"</TD>\n");
		writer.write("<TD align=left valign=middle nowrap>"+oVolume.AppearedPeople[personno].title.join("<BR>\n")+"</TD>\n");
		writer.write("</TR>\n");
	}
	writer.write("</TABLE>\n");
	writer.write(template[1]);
	if(oVolume.wakaAkiko && oVolume.wakaAkiko!="") {
		writer.write("<TR>\n");
		writer.write("<TH class=cCombined nowrap><BR></TH>\n");
		writer.write("<TD class=cTanka    nowrap colspan=2><BLOCKQUOTE><B>"+oVolume.wakaAkiko+"</B></BLOCKQUOTE></TD>\n");
		writer.write("</TR>\n");
	}
	else {
		//writer.write("<SCRIPT>linktoYosano.style.display='none';</SCRIPT>\n");
	}
	for(noChapter=0;noChapter<oVolume.Chapters.length;++noChapter) {
		var oChapter = oVolume.Chapters[noChapter];
		fileid[1] = no+"."+oChapter.id;
		fileid[2] = no+"."+oChapter.id+".1";
		fileid[3] = no+"."+oChapter.id;
		filename="combined"+fileid[filelevel]+".html"
		writer.write(template[2].replace(/<%=oChapter\.title%>/g, oChapter.title)
		                        .replace(/<%=oChapter\.id%>/g,    oChapter.id)
		                        .replace(/<%=filename%>/g,       filename));
		for(noParagraph=0;noParagraph < oChapter.Paragraphs.length;++noParagraph) {
			var oParagraph = oChapter.Paragraphs[noParagraph];
			var i;
			fileid[2] = no+"."+oParagraph.id;
			fileid[3] = no+"."+oParagraph.id;
			filename="combined"+fileid[filelevel]+".html"
			writerTanka.clear();
			writerTanka.writeln("<TABLE>");
			for(i=0; i < oParagraph.tankas.length; ++i) {
				var tanka = oParagraph.tankas[i];
				if(tanka && tanka.genbun && tanka.lineid) {
					writerTanka.writeln("<TR><TD valign=middle><A href=\""+filename+"#line"+tanka.lineid+"\">"+tanka.lineid.replace(/^.*\./,"")+"行</A></TD>"
					                       +"<TD nowrap>"+tanka.genbun.replace(/[ 　▼★☆「」『』\t]*/g, "")+"</TD></TR>");
				}
			}
			writerTanka.writeln("</TABLE>");
			writerImage.clear();
			writerImage.write("<TABLE><TR>\n");
			var lines = oParagraph["genbun"] .length;
			if( lines < oParagraph["yakubun"].length) lines = oParagraph["yakubun"].length;
			if( lines < oParagraph["roman"]  .length) lines = oParagraph["roman"]  .length;
			if( lines < oParagraph["yosano"] .length) lines = oParagraph["yosano"] .length;
			var linkto="paragraph"+oParagraph.id;
			for(line=0;line<lines;++line) {
				if(line < oParagraph.images.length && oParagraph.images[line]) {
					writerImage.write("<TD><A href="+filename+"#"+linkto+">"+line+"行<BR><IMG src=\""+imgdir+oParagraph.images[line]+"\"></A></TD>\n");
				}
				linkto = "line"+oParagraph.id+"."+(line+1);
			}
			writerImage.write("</TR></TABLE>\n");
			writer.write(template[3]
				.replace(/<%=filename%>/g, filename)
				.replace(/<%=oParagraph\.id%>/g, oParagraph.id)
				.replace(/<%=oParagraph\.title%>/g, oParagraph.title)
				.replace(/<%=intro_genbun%>/g, oVolume["intro_genbun"] [oParagraph.hrefid].intro)
				.replace(/<%=intro_yakubun%>/g, oVolume["intro_yakubun"][oParagraph.hrefid].intro)
				.replace(/<%=intro_notes%>/g, oVolume["intro_notes"]  [oParagraph.hrefid].intro)
				.replace(/<%=intro_roman%>/g, oVolume["intro_roman"]  [oParagraph.hrefid].intro)
				.replace(/<%=refTanka%>/g, writerTanka.string)
				.replace(/<%=refImage%>/g, writerImage.string)
				);
		}
	}
	writer.write(template[4]);

	return writer.string;
}
var writerMokuji        = null;
var writerMokujiEnglish = null;
var writerText          = null;
//var writerHtml          = null;
var writerVersion       = null;
var writerYosano        = null;
var writerRomaji        = null;
var writerNotes         = null;
var writerSource        = null;
var writerRevice        = null;
var writerSashie        = null;
var writerWaka          = null;
var writerPerson        = null;
var writerCopyright     = null;
//var writerHiragana      = null;

function CreateCsvFiles()
{
	writerMokuji        = new MyStreamWriter(csvdir+"mokuji.csv");
	writerMokujiEnglish = new MyStreamWriter(csvdir+"mokujiEnglish.csv");
	writerText          = new MyStreamWriter(csvdir+"text.csv");
	//writerHtml          = new MyStreamWriter(csvdir+"html.csv");
	writerVersion       = new MyStreamWriter(csvdir+"version.csv");
	writerYosano        = new MyStreamWriter(csvdir+"yosano.csv");
	writerRomaji        = new MyStreamWriter(csvdir+"romaji.csv");
	writerNotes         = new MyStreamWriter(csvdir+"notes.csv");
	writerSource        = new MyStreamWriter(csvdir+"source.csv");
	writerRevice        = new MyStreamWriter(csvdir+"revice.csv");
	writerSashie        = new MyStreamWriter(csvdir+"sashie.csv");
	writerWaka          = new MyStreamWriter(csvdir+"waka.csv");
	writerPerson        = new MyStreamWriter(csvdir+"person.csv");
	writerCopyright     = new MyStreamWriter(csvdir+"copyright.csv");
	//writerHiragana      = new MyStreamWriter(csvdir+"hiragana.csv");

	writerMokuji       .writeline('種別,帖,章,段,タイトル');
	writerMokujiEnglish.writeline('種別,帖,章,段,タイトル');
	writerText         .writeline('帖,章,段,行,内容');
	//writerHtml         .writeline('oVolume,章,段,行,内容');
	writerVersion      .writeline('帖,章,段,行,内容');
	writerYosano       .writeline('帖,章,段,行,内容');
	writerRomaji       .writeline('帖,章,段,行,内容');
	writerNotes        .writeline('帖,章,段,行,注釈番号,状態,見出し,注釈');
	writerSource       .writeline('帖,章,段,行,出典番号,見出し,引用文,出典');
	writerRevice       .writeline('帖,章,段,行,校訂番号,見出し,校訂');
	writerSashie       .writeline('帖,章,段,行,ファイル名');
	writerWaka         .writeline('帖,章,段,行_上の句,行_下の句');
	writerPerson       .writeline('帖,登場人物,読み,呼称,備考');
	writerCopyright    .writeline('帖,種別,著作権');
	//writerHiragana    .writeline('帖,章,段,行,内容');
}

function CloseCsvFiles()
{
	writerMokuji       .Close();
	writerMokujiEnglish.Close();
	writerText         .Close();
	//writerHtml         .Close();
	writerVersion      .Close();
	writerYosano       .Close();
	writerRomaji       .Close();
	writerNotes        .Close();
	writerSource       .Close();
	writerRevice       .Close();
	writerSashie       .Close();
	writerWaka         .Close();
	writerPerson       .Close();
	writerCopyright    .Close();
	//writerHiragana     .Close();
}

function saveCsvFiles(oVolume, prmChapter, prmParagraph)
{
	if(writerMokuji==null) {
		CreateCsvFiles();
	}
	docProgress.write(oVolume.title + " CSV出力<br>\n")

	var original = "http://www.sainet.or.jp/~eshibuya/";
	var yosano   = "http://www.genji.co.jp/yosano/";
	var no = oVolume.id;
	var title=oVolume.title;

	writerMokuji       .writeline('book,'    +no+',0,0,"'+oVolume.title    +'"');
	writerMokuji       .writeline('subtitle,'+no+',0,0,"'+oVolume.subtitle +'"');
	writerMokujiEnglish.writeline('book,'    +no+',0,0,"'+oVolume.title2   +'"');
	writerMokujiEnglish.writeline(('subtitle,'+no+',0,0,"'+oVolume.subtitle2+'"').replace(/&nbsp;/g, " ").replace(/<[\/]*I>/g, ""));

	writerCopyright.writeline(no+',text,"'   +oVolume["address_genbun"] +'","'+original+'text'   +no+'.html"');
	writerCopyright.writeline(no+',notes,"'  +oVolume["address_notes"]  +'","'+original+'note'   +no+'.html"');
	writerCopyright.writeline(no+',version,"'+oVolume["address_yakubun"]+'","'+original+'version'+no+'.html"');
	writerCopyright.writeline(no+',romaji,"' +oVolume["address_roman"].replace(" by ","<br>by ")+'","'+original+'roman'+no+'.html"');
	if(oVolume.wakaAkiko && oVolume.wakaAkiko!="") {
		writerCopyright.writeline(no+',yosano,"'+address_yosano_const+'","'+yosano+"yy"+no+'.html"');
	}
	writerCopyright.writeline(no+',sashie,"'+oVolume["address_image"].replace(/"/g, "'")+'",');

	for(noChapter=0;noChapter<oVolume.Chapters.length;++noChapter) {
		var oChapter = oVolume.Chapters[noChapter];
		var chapterNo = noChapter + 1;
		if(prmChapter!=0) {
			 if( chapterNo != prmChapter) continue;
			 title=title + "　" + oChapter.title;
		}
		writerMokuji       .writeline('chapter,'+no+','+chapterNo+',0,"'+oChapter.title +'"');
		writerMokujiEnglish.writeline(('chapter,'+no+','+chapterNo+',0,"'+oChapter.title2+'"').replace(/&nbsp;/g, " ").replace(/<[\/]*I>/g, ""));
		for(noParagraph=0;noParagraph < oChapter.Paragraphs.length;++noParagraph) {
			var oParagraph = oChapter.Paragraphs[noParagraph];
			var paragraphNo = noParagraph + 1;
			if(prmParagraph!=0) {
				if((noParagraph+1)!=prmParagraph) continue;
				title=title + "　" + oParagraph.title;
			}
			writerMokuji       .writeline('paragraph,'+no+','+chapterNo+','+paragraphNo+',"'+oParagraph.title +'"');
			writerMokujiEnglish.writeline(('paragraph,'+no+','+chapterNo+','+paragraphNo+',"'+oParagraph.title2+'"').replace(/&nbsp;/g, " ").replace(/<[\/]*I>/g, ""));
			var lines = oParagraph["genbun"] .length;
			if( lines < oParagraph["yakubun"].length) lines = oParagraph["yakubun"].length;
			if( lines < oParagraph["roman"]  .length) lines = oParagraph["roman"]  .length;
			if( lines < oParagraph["yosano"] .length) lines = oParagraph["yosano"] .length;
			for(line=0;line<lines;++line) {
				var lineNo = (line+1);
				var lineid = oParagraph.id+"."+lineNo;
				//writerHtml   .writeline(no+','+chapterNo+','+paragraphNo+','+lineNo+',"'
				//                       +chk(oParagraph["genbun"] [line]).replace(/ title="[^"]*"/g, "")
				//                                                           .replace(/"/g,"'") +'"');
				writerText   .writeline(no+','+chapterNo+','+paragraphNo+','+lineNo+',"'
				                       +chk(oParagraph["genbun"] [line]).replace(/<(\/A|\/SPAN)>/g, "")
				                                                           .replace(/<BR> *$/g, "")
				                                                           .replace(/<(BR|HR)>/g, "#$1#")
				                                                           .replace(/<(A|SPAN) [^<>]*>/g, "")
				                                                           .replace(/#(BR|HR)#/g, "<$1>")
				                                                           .replace(/[▼★☆ ]/g, "") +'"');
				writerVersion.writeline(no+','+chapterNo+','+paragraphNo+','+lineNo+',"'
				                       +chk(oParagraph["yakubun"][line]).replace(/<BR> *$/g, "")
				                                                           .replace(/<\/SPAN>/g, "")
				                                                           .replace(/<SPAN [^<>]*>/g, "") +'"');
				writerYosano .writeline(no+','+chapterNo+','+paragraphNo+','+lineNo+',"'
				                       +chk(oParagraph["yosano"] [line]).replace(/<br> *$/g, "")
				                                                           +'"');
				writerRomaji .writeline(no+','+chapterNo+','+paragraphNo+','+lineNo+',"'
				                       +chk(oParagraph["roman"]  [line]).replace(/<BR> *$/g, "")
				                                                           .replace(/<\/SPAN>/g, "")
				                                                           .replace(/<SPAN [^<>]*>/g, "")
				                                                           .replace(/"/g,"&#34;")
				                                                           .replace(/,/g,"&#44;") +'"');
				//writerHiragana .writeline(no+','+chapterNo+','+paragraphNo+','+lineNo+',"'+chk(oParagraph["hiragana"] [line]) +'"');
				//writerHiragana .writeline(no+','+chapterNo+','+paragraphNo+','+lineNo+',"'+cvRoman2Hiragana(chk(oParagraph["roman"] [line])) +'"');
				if(/*line < oParagraph.images.length &&*/ oParagraph.images[line]) {
					writerSashie.writeline(no+','+chapterNo+','+paragraphNo+','+lineNo+',"'+imgdir+oParagraph.images[line]+'"');
				}
				if(oParagraph.tankas[line]) {
					writerWaka.writeline(no+','+chapterNo+','+paragraphNo+','+lineNo);
				}
			}

			//注釈
			for(noteno=0; noteno < oParagraph.notes.length; ++noteno) {
				var note = oParagraph.notes[noteno];
				var lineNo = "";
				if(note.lineid) {
					lineNo = note.lineid.split(".")[2];
				}
				writerNotes.writeline(no+','+chapterNo+','+paragraphNo+','+lineNo
					+ ',' +note.noteno
					+ ',' +note.found
					+ ',"'+note.keyword
					+'","'+note.comment+'"');
			}

			//出典
			for(srcno=0; srcno < oParagraph.sources.length; ++srcno) {
				var source = oVolume.Sources[oParagraph.sources[srcno]];
				var lineNo = "";
				if(source.lineid) {
					lineNo = source.lineid.split(".")[2];
				}
				writerSource.writeline(no+','+chapterNo+','+paragraphNo+','+lineNo
					+ ',' +source.hrefid.split("no")[1]
					+ ',"'+source.keyword
					+'","'+source.source
					+'","'+source.author
					+'"');
			}

			//校訂
			for(reviseno=0; reviseno < oParagraph.revises.length; ++reviseno) {
				var revise = oVolume.Revises[oParagraph.revises[reviseno]];
				var lineNo = "";
				if(revise.lineid) {
					lineNo = revise.lineid.split(".")[2];
				}
				writerRevice.writeline(no+','+chapterNo+','+paragraphNo+','+lineNo
					+ ',' +revise.hrefid.split("k")[1]
					+ ',"'+revise.keyword
					+'","'+revise.comment
					+'"');
			}

		}
	}
	//登場人物
	for(personno=0;personno<oVolume.AppearedPeople.length; ++personno) {
		writerPerson.write(no+','+
		                   oVolume.AppearedPeople[personno].name+"," +
		                   oVolume.AppearedPeople[personno].yomi+"," +
		                   oVolume.AppearedPeople[personno].koshou.join(";")+"," +
		                   oVolume.AppearedPeople[personno].title.join(";")+"\n");
	}
}
