﻿function DiffYosano(no)
{
	MyLog("第"+no+"帖を比較しています。");
	if(diffAozora( yosano2dir+"aozora/aozora"+no+".html",
	               yosanodir+"yosano"+no+".html",
	               yosano2dir+"diff/aozora-yosano"+no+".html")) { }
	/*
	if(diffVersion( modifieddir+"version"+no+".html",
	                yosanodir+"yosano"+no+".html",
	                yosano2dir+"diff/version-yosano"+no+".html")) { }
	else if(diffVersion( originaldir+"version"+no+".html",
	                     yosanodir+"yosano"+no+".html",
	                     yosano2dir+"diff/version-yosano"+no+".html")) { }
	*/
}

function FileExists(originalFilename, modifiedFileName)
{
	if(!fso.FileExists(originalFilename)) {
		MyLog("ファイル("+originalFilename+")が見つかりません。");
		myReportWriter.write("ファイル("+originalFilename+")が見つかりません。\n");
		return false;
	}
	if(!fso.FileExists(modifiedFileName)) {
		MyLog("ファイル("+modifiedFileName+")が見つかりません。");
		myReportWriter.write("ファイル("+modifiedFileName+")が見つかりません。\n");
		return false;
	}
	return true;
}

function diffAozora(originalFilename, modifiedFileName, reportFileName)
{
	if(!FileExists(originalFilename, modifiedFileName)) return false;
	var strOriginal = ReadWholeFile(originalFilename).replace(/[ \t\r]*\n/g, "\n");
	var strModified = ReadWholeFile(modifiedFileName).replace(/[ \t\r]*\n/g, "\n");
	strOriginal=strOriginal.replace(/^(?:.*\n)*.*（晶子）\s*(?:<\/DIV>|<BR>|　|\s)*|<\/?(?:DIV|STRONG)[^<>]*>|底本：「全訳源氏物語(.*\n)*.*$/g, "")
	                       .replace(/<RUBY><RB>([^<>]+)<\/RB>(?:<RP>[^<>]+<\/RP>|<RT>[^<>]+<\/RT>)*<\/RUBY>/g, "$1")
	                       .replace(/^\n+|(?:<BR>|<HR>|[ 　\t\n])+$/gi, "");
	strModified=strModified.replace(/^(?:.*\n)*.*<H3>.*<\/H3>.*\n|(?:\n　*|<P>|<BR>|<HR[^<>\n]*>|<H4>.*<\/H4>(?:<BR>)?|<A [^<>\n]*>.*<\/A>(?:<BR>)?)+/g, "\n")
	                       .replace(/<RUBY><RB>([^<>]+)<\/RB>(?:<RP>[^<>]+<\/RP>|<RT>[^<>]+<\/RT>)*<\/RUBY>/g, "$1")
	                       .replace(/^\n+|(?:<\/body>|<\/html>|<BR>|<HR[^<>]*>|<P>|[ 　\t\n]+)*$/gi, "");
	diffFile(strOriginal, strModified, originalFilename, modifiedFileName, reportFileName);
	return true;
}

function diffVersion(originalFilename, modifiedFileName, reportFileName)
{
	/*
	if(!FileExists(originalFilename, modifiedFileName)) return false;
	var strOriginal = ReadWholeFile(originalFilename).replace(/[ \t\r]*\n/g, "\n");
	var strModified = ReadWholeFile(modifiedFileName).replace(/[ \t\r]*\n/g, "\n");
	diffFile(strOriginal, strModified, originalFilename, modifiedFileName, reportFileName);
	*/
	return true;
}

function diffFile(strOriginal, strModified, originalFilename, modifiedFileName, reportFileName)
{
	CreateParentFolder(reportFileName);
	var fpReport = new MyStreamWriter(reportFileName);
	var original = strOriginal.split("\n");
	var modified = strModified.split("\n");
	var orgLines = original.length;
	var modLines = modified.length;
	var org = 0;
	var mod = 0;
	var minLength = 16;

	fpReport.write("<html>\n");
	fpReport.write("<head>\n");
	fpReport.write("<META http-equiv=Content-Type content='text/html; charset=UTF-8'>\n");
	fpReport.write("<LINK id=myStyleSheet href='"+htmldir+"css/diffNN.css' rel='STYLESHEET' type='text/css'>\n");
	fpReport.write("</head>\n");
	fpReport.write("<body onload='window_onload()'>\n");
	fpReport.write("<SCRIPT src='"+htmldir+"scripts/diffNN.js'>\n");
	fpReport.write("</"+"SCRIPT>\n");
	fpReport.write("<table border=1 cellspacing=0>\n");
	fpReport.write("<tr><th width=50%>"+originalFilename+"</th><th width=50%>"+modifiedFileName+"</th></tr>\n");
	while(org<orgLines || mod<modLines) {
		if( org<orgLines && mod<modLines &&
			original[org] == modified[mod]) {
			//行一致
			fpReport.write("<tr class=cTrSameLine>" +
			                   "<td><font color=silver>"+original[org]+"</font></td>" +
			                   "<td>&nbsp;</td>" +
			                   "</tr>\n");
			org++;
			mod++;
			continue;
		}
		var flg = "";
		for(diff=1;;diff++)
		{
			flg = "";
			org2=org+diff;
			mod2=mod+diff;
			if( ( org2<orgLines &&
			      mod2<modLines &&
			      original[org2].length>=minLength &&
			      modified[mod2].length>=minLength &&
				  original[org2] == modified[mod2]) ||
				( org2==orgLines &&
			      mod2==modLines       )  )
			{
				//修正(行数増減なし)
				flg = "c"+diff;
				break;
			}
			else {
				for(k=1;k<=diff;++k) {
					org2=org+diff-k;
					mod2=mod+diff;
					if( ( org2<orgLines &&
					      mod2<modLines &&
					      original[org2].length>=minLength &&
					      modified[mod2].length>=minLength &&
						  original[org2] == modified[mod2]) ||
						( org2==orgLines &&
					      mod2==modLines       )  )
					{
						if(org==org2) {
							//行挿入
							flg = "i"+diff;
						}
						else {
							//修正(行数増加)
							flg = "c"+(diff-k)+"+"+k;
						}
						break;
					}
					else {
						org2=org+diff;
						mod2=mod+diff-k;
						if( ( org2<orgLines &&
						      mod2<modLines &&
						      original[org2].length>=minLength &&
						      modified[mod2].length>=minLength &&
							  original[org2] == modified[mod2]) ||
							( org2==orgLines &&
						      mod2==modLines       )  )
						{
							if(mod==mod2) {
								//行削除
								flg = "d"+diff;
							}
							else {
								//修正(行数減少)
								flg = "c"+diff+"-"+k;
							}
							break;
						}
					}
				}
				if(flg != "") break;
			}
		}

		var left="";
		for(org1=org;org<org2;org++) {
			left = left + "《改行》" + original[org];
		}
		left = left.substr(4);

		var right="";
		for(mod1=mod;mod<mod2;mod++) {
			right = right + "《改行》" + modified[mod];
		}
		right = right.substr(4);
		var outL = "";
		var outR = "";
		if(flg.substr(0,1)=="c") {
			function DiffChars(left, right, minsz) {//文字単位の比較
				var CharsL  = left.length;
				var CharsR = right.length;
				var L = 0;
				var R = 0;
				while(L<CharsL || R<CharsR) {
					if( L<=CharsL-minsz &&
					    R<=CharsR-minsz &&
					    left.substr(L,minsz) == right.substr(R,minsz))
					{
						//文字一致
						var len = minsz;
						while (L+len<=CharsL-1 &&
						       R+len<=CharsR-1 &&
						       left.substr(L+len,1) == right.substr(R+len,1) )
						{
							len++;
						}
						outL = outL + left .substr(L,len).replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/《改行》/g, "<B>《改行》</B><BR>");
						outR = outR + right.substr(R,len).replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/《改行》/g, "<B>《改行》</B><BR>");
						L+=len;
						R+=len;
						continue;
					}
					var cflg = "";
					var L2 = 0;
					var R2 = 0;
					for(diff=1;;diff++) {
						L2=L+diff;
						R2=R+diff;
						if( ( ( L2<=CharsL-minsz && R2<=CharsR-minsz            ) &&
						      ( left.substr(L2,minsz) == right.substr(R2,minsz) )  ) ||
						    (   L2==CharsL   && R2==CharsR                         )  )
						{
							//文字修正
							cflg = "c";
							break;
						}
						else {
							for(k=1;k<=diff;++k) {
								L2=L+diff-k;
								R2=R+diff;
								if( ( ( L2<=CharsL-minsz && R2<=CharsR-minsz            ) &&
								      ( left.substr(L2,minsz) == right.substr(R2,minsz) )  ) ||
								    (   L2==CharsL   && R2==CharsR                         )  )
								{
									if(L==L2) {
										//文字挿入
										cflg = "i";
									}
									else {
										//修正(文字数増加)
										cflg = "c+";
									}
									break;
								}
								else {
									L2=L+diff;
									R2=R+diff-k;
									if( ( ( L2<=CharsL-minsz && R2<=CharsR-minsz            ) &&
									      ( left.substr(L2,minsz) == right.substr(R2,minsz) )  ) ||
									    (   L2==CharsL   && R2==CharsR                         )  )
									{
										if(R==R2) {
											//文字削除
											cflg = "d";
										}
										else {
											//修正(文字数減少)
											cflg = "c-";
										}
										break;
									}
								}
							}
							if(cflg != "") break;
						}
					}
					switch(0) {
					case 0:
						if(minsz!=1 && cflg!="i" && cflg!="d") {
							var newsz = Math.floor((L2-L+R2-R)/16)+1;
							if(newsz>Math.floor((minsz+1)/2)) newsz=Math.floor((minsz+1)/2);
							DiffChars(left .substr(L,L2-L),
							          right.substr(R,R2-R), newsz);
							L = L2;
							R = R2;
							break
						}
						if(cflg!="i") {
							outL = outL + "<b style='background:yellow; color=red'>" + left .substr(L,L2-L).replace(/</g, "&lt;")
							                                                                               .replace(/>/g, "&gt;")
							                                                                               .replace(/《改行》/g, "《改行》<BR>") + "</b>";
							L = L2;
						}
						if(cflg!="d") {
							outR = outR + "<b style='background:yellow; color=red'>" + right.substr(R,R2-R).replace(/</g, "&lt;")
							                                                                               .replace(/>/g, "&gt;")
							                                                                               .replace(/《改行》/g, "《改行》<BR>") + "</b>";
							R = R2;
						}
						if(outR.indexOf("《改行》")>=0) {
							fpReport.write("<tr>" +
							               "<td>"+outL+"</td>" +
							               "<td>"+outR+"</td>" +
							               "</tr>\n");
							outL="";
							outR="";
						}
					}
				}
			}
			DiffChars(left, right, 8);
		}
		else {
			outL = left .replace(/</g, "&lt;")
					    .replace(/>/g, "&gt;")
					    .replace(/《改行》/g, "<B>《改行》</B><BR>");
			outR = right.replace(/</g, "&lt;")
					    .replace(/>/g, "&gt;")
					    .replace(/《改行》/g, "<B>《改行》</B><BR>");
		}

		
		fpReport.write("<tr>" +
		               "<td>"+outL+"</td>" +
		               "<td>"+outR+"</td>" +
		               "</tr>\n");
	}
	fpReport.write("</table></body></html>\n");
	fpReport.Close();
}
