﻿//メインパーサの正規表現
var re_Main = /<TITLE>((?:([0-9][0-9])\s+)?(.*?)(?:[（(](.*)[）)])?)(?:[ 　]|&nbsp;)*(本文|注釈|現代語訳|与謝野晶子訳|Japanese roman letters)?<\/TITLE>|<H3>(.*)<\/H3>(?:\s+([^\s\[\]<>]+)<BR\/?>)?|<P class=wakaAkiko>(.*)|<ADDRESS>((?:.*\n)*?.*?)(?:<BR\/?>)?<\/ADDRESS>|<DT>[　 ]*(.*?)(?:<|&lt;)(.*?)(?:&gt;|>)\s+<DD>呼称-+(.*?)(?:、(.*))?<BR\/?>|<H4>(.*)<\/H4>|<A name="?in([0-9]*)"?>(?:【(出典|校訂)】|\[(.+)\])(?:<\/A>|<BR\/?>)+|<A name="?no([0-9]+)"?>(出典[0-9]+)<\/A>　*(.*)<A href="#te[0-9]*">(?:（戻）|戻る)<\/A>|<A name="?k([0-9]+)"?>(校訂[0-9]+)<\/A>　*(.*)<A href="#(te?[0-9]*)">(?:（戻）|戻る)<\/A>|<A name="?(te?[0-9]+)"?>(?=(?:<BR\/?>|[^<>])*<\/A>)|(<A href="#no([0-9]+)">)((?:[^<>]+|<BR\/?>|<P>|<A (?:href="#k[0-9]+"|name="t[0-9]+")>[^<>]*<\/A>)*)<\/A>|(<A href="#k([0-9]+)">)((?:[^<>]+|<BR\/?>|<P>)*)<\/A>|<A href="((text|note|version|note)[0-9]+\.html)">[^<>]+<\/A>|<IMG src="([^\"]*)"[^<>]*>|<RUBY><RB>(.*?)(?:<\/RB>)?(?:<RP>[^<>]*(?:<\/RP>)?)?<RT>([^<>]*)(?:<\/RT>)?(?:<RP>[^<>]*(?:<\/RP>)?)?<\/RUBY>|<(\/?\w+).*?>|<!--(.*?)-->|<DT>　(.*)&lt;(.*)&gt;|((?:備考.*　朱筆--&lt;朱&gt;|【校訂方針】)[^<>\r\n]*)|((?:&#?\w+;)+)|【([^【】]*)】－ *((?:[^<>\n]+|<BR\/?>)+)|(?:[""'']?<I>([-a-zA-Z''!? ]+)<BR>(?:　|&nbsp;)+([-a-zA-Z''!? ]+)<\/I>[""'']?<BR>)|(\n(?:<P>|\s|　|&nbsp;)*)|([「」『』])|(&#([0-9]+);)|([^<>&「」『』\n]+)/gi

/*
var re_Main = /<TITLE>((?:([0-9][0-9])\s+)?(.*?)(?:[（(](.*)[）)])?)(?:[ 　]|&nbsp;)*(本文|注釈|現代語訳|与謝野晶子訳|Japanese roman letters)?<\/TITLE>|<H3>(.*)<\/H3>(?:\s+([^\s\[\]<>]+)<BR\/?>)?|<P class=wakaAkiko>(.*)|<ADDRESS>((?:.*\n)*?.*?)(?:<BR\/?>)?<\/ADDRESS>|<DT>[　 ]*(.*?)(?:<|&lt;)(.*?)(?:&gt;|>)\s+<DD>呼称-+(.*?)(?:、(.*))?<BR\/?>|<H4>(.*)<\/H4>|<A name="?in([0-9]*)"?>(?:【(出典|校訂)】|\[(.+)\])(?:<\/A>|<BR\/?>)+|<A name="?no([0-9]+)"?>(出典[0-9]+)<\/A>　*(.*)<A href="#te[0-9]*">(?:（戻）|戻る)<\/A>|<A name="?k([0-9]+)"?>(校訂[0-9]+)<\/A>　*(.*)<A href="#(te?[0-9]*)">(?:（戻）|戻る)<\/A>|<A name="?(te?[0-9]+)"?>(?=(?:<BR\/?>|[^<>])*<\/A>)|(<A href="#no([0-9]+)">)((?:[^<>]+|<BR\/?>|<P>|<A (?:href="#k[0-9]+"|name="t[0-9]+")>[^<>]*<\/A>)*)<\/A>|(<A href="#k([0-9]+)">)((?:[^<>]+|<BR\/?>|<P>)*)<\/A>|<A href="((text|note|version|note)[0-9]+\.html)">[^<>]+<\/A>|<IMG src="([^\"]*)"[^<>]*>|<RUBY><RB>(.*?)(?:<\/RB>)?(?:<RP>[^<>]*(?:<\/RP>)?)?<RT>([^<>]*)(?:<\/RT>)?(?:<RP>[^<>]*(?:<\/RP>)?)?<\/RUBY>|<(\/?\w+).*?>|<!--(.*?)-->|<DT>　(.*)&lt;(.*)&gt;|((?:備考.*　朱筆--&lt;朱&gt;|【校訂方針】)[^<>\r\n]*)|(&nbsp;&nbsp;|#?\w+;)|【([^【】]*)】－ *((?:[^<>\n]+|<BR\/?>)+)|(?:(?:　|&nbsp;)*[""'']?<I>([-a-zA-Z''!? ]+)<BR>(?:　|&nbsp;)+([-a-zA-Z''!? ]+)<\/I>[""'']?<BR>)|(\n(?:<P>|\s|　|&nbsp;)*)|([「」『』])|(&#([0-9]+);)|([^<>&「」『』\n]+)/gi
*/

/* JScriptでも継続行は使えるようだが、なぜか、うまくいかない。
var re_Main = /<TITLE>((?:([0-9][0-9])\s+)?(.*?)(?:[（(](.*)[）)])?)(?:[ 　]|&nbsp;)*(本文|注釈|現代語訳|与謝野晶子訳|Japanese roman letters)?<\/TITLE>|\
<H3>(.*)<\/H3>(?:\s+([^\s\[\]<>]+)<BR\/?>)?|\
<P class=wakaAkiko>(.*)|\
<ADDRESS>((?:.*\n)*?.*?)(?:<BR\/?>)?<\/ADDRESS>|\
<DT>[　 ]*(.*?)(?:<|&lt;)(.*?)(?:&gt;|>)\s+<DD>呼称-+(.*?)(?:、(.*))?<BR\/?>|\
<H4>(.*)<\/H4>|\
<A name="?in([0-9]*)"?>(?:【(出典|校訂)】|\[(.+)\])(?:<\/A>|<BR\/?>)+|\
<A name="?no([0-9]+)"?>(出典[0-9]+)<\/A>　*(.*)<A href="#te[0-9]*">(?:（戻）|戻る)<\/A>|\
<A name="?k([0-9]+)"?>(校訂[0-9]+)<\/A>　*(.*)<A href="#(te?[0-9]*)">(?:（戻）|戻る)<\/A>|\
<A name="?(te?[0-9]+)"?>(?=(?:<BR\/?>|[^<>])*<\/A>)|\
(<A href="#no([0-9]+)">)((?:[^<>]+|<BR\/?>|<P>|<A (?:href="#k[0-9]+"|name="t[0-9]+")>[^<>]*<\/A>)*)<\/A>|\
(<A href="#k([0-9]+)">)((?:[^<>]+|<BR\/?>|<P>)*)<\/A>|\
<A href="((text|note|version|note)[0-9]+\.html)">[^<>]+<\/A>|\
<IMG src="([^\"]*)"[^<>]*>|\
<RUBY><RB>(.*?)(?:<\/RB>)?(?:<RP>[^<>]*(?:<\/RP>)?)?<RT>([^<>]*)(?:<\/RT>)?(?:<RP>[^<>]*(?:<\/RP>)?)?<\/RUBY>|\
<(\/?\w+).*?>|\
<!--(.*?)-->|\
<DT>　(.*)&lt;(.*)&gt;|\
((?:備考.*　朱筆--&lt;朱&gt;|【校訂方針】)[^<>\r\n]*)|\
(&nbsp;&nbsp;|#?\w+;)|\
【([^【】]*)】－ *((?:[^<>\n]+|<BR\/?>)+)|\
(?:(?:　|&nbsp;)+[""'']?<I>([-a-zA-Z''!? ]+)<BR\/?>(?:　|&nbsp;)+([-a-zA-Z''!? ]+)<\/I>[""'']?(?=<BR\/?>\n))|\
(\n(?:<P>|\s|　|&nbsp;)*)|\
([「」『』])|(&#([0-9]+);)|\
([^<>&「」『』\n]+)/gi
*/

/*
var re_Main = /<TITLE>((?:([0-9][0-9])\s+)?(.*?)(?:[（(](.*)[）)])?)(?:[ 　]|&nbsp;)*(本文|注釈|現代語訳|与謝野晶子訳|Japanese roman letters)?<\/TITLE>|\
<H3>(.*)<\/H3>(?:\s+([^\s\[\]<>]+)<BR\/?>)?|\
<P class=wakaAkiko>(.*)|\
<ADDRESS>((?:.*\n)*?.*?)(?:<BR\/?>)?<\/ADDRESS>|\
<DT>[　 ]*(.*?)(?:<|&lt;)(.*?)(?:&gt;|>)\s+<DD>呼称-+(.*?)(?:、(.*))?<BR\/?>|\
<H4>(.*)<\/H4>|\
<A name="?in([0-9]*)"?>(?:【(出典|校訂)】|\[(.+)\])(?:<\/A>|<BR\/?>)+|\
<A name="?no([0-9]+)"?>(出典[0-9]+)<\/A>　*(.*)<A href="#te[0-9]*">(?:（戻）|戻る)<\/A>|\
<A name="?k([0-9]+)"?>(校訂[0-9]+)<\/A>　*(.*)<A href="#(te?[0-9]*)">(?:（戻）|戻る)<\/A>|\
<A name="?(te?[0-9]+)"?>(?=(?:<BR\/?>|[^<>])*<\/A>)|\
(<A href="#no([0-9]+)">)((?:[^<>]+|<BR\/?>|<P>|<A (?:href="#k[0-9]+"|name="t[0-9]+")>[^<>]*<\/A>)*)<\/A>|\
(<A href="#k([0-9]+)">)((?:[^<>]+|<BR\/?>|<P>)*)<\/A>|\
<A href="((text|note|version|note)[0-9]+\.html)">[^<>]+<\/A>|\
<IMG src="([^\"]*)"[^<>]*>|\
<RUBY><RB>(.*?)(?:<\/RB>)?(?:<RP>[^<>]*(?:<\/RP>)?)?<RT>([^<>]*)(?:<\/RT>)?(?:<RP>[^<>]*(?:<\/RP>)?)?<\/RUBY>|\
<(\/?\w+).*?>|\
<!--(.*?)-->|\
<DT>　(.*)&lt;(.*)&gt;|\
((?:備考.*　朱筆--&lt;朱&gt;|【校訂方針】)[^<>\r\n]*)|\
(&nbsp;&nbsp;|#?\w+;)|\
【([^【】]*)】－ *((?:[^<>\n]+|<BR\/?>)+)|\
(?:当面、和歌は未サポート\n(?:　|&nbsp;)+([""'']?<I>[''""]?)((?:[^<>]+|<\/?A\b[^<>]*>)+?)<BR\/?>\n?(?:　|&nbsp;)+((?:[^<>]+|<\/?A\b[^<>]*>)+?)([""'']?<\/I>[""'']?)(?=<BR\/?>?\n))|\
(\n(?:<P>|\s|　|&nbsp;)*)|\
([「」『』])|(&#([0-9]+);)|\
([^<>&「」『』\n]+)/gi
*/

//var re_Main = /<TITLE>((?:([0-9][0-9])\s+)?(.*?)(?:[（(](.*)[）)])?)(?:[ 　]|&nbsp;)*(本文|注釈|現代語訳|与謝野晶子訳|Japanese roman letters)?<\/TITLE>|<H3>(.*)<\/H3>(?:\s+([^\s\[\]<>]+)<BR\/?>)?|<P class=wakaAkiko>(.*)|<ADDRESS>((?:.*\n)*?.*?)(?:<BR\/?>)?<\/ADDRESS>|<DT>[　 ]*(.*?)(?:<|&lt;)(.*?)(?:&gt;|>)\s+<DD>呼称-+(.*?)(?:、(.*))?<BR\/?>|<H4>(.*)<\/H4>|<A name="?in([0-9]*)"?>(?:【(出典|校訂)】|\[(.+)\])(?:<\/A>|<BR\/?>)+|<A name="?no([0-9]+)"?>(出典[0-9]+)<\/A>　*(.*)<A href="#te[0-9]*">(?:（戻）|戻る)<\/A>|<A name="?k([0-9]+)"?>(校訂[0-9]+)<\/A>　*(.*)<A href="#(te?[0-9]*)">(?:（戻）|戻る)<\/A>|<A name="?(te?[0-9]+)"?>(?=(?:<BR\/?>|[^<>])*<\/A>)|(<A href="#no([0-9]+)">)((?:[^<>]+|<BR\/?>|<P>|<A (?:href="#k[0-9]+"|name="t[0-9]+")>[^<>]*<\/A>)*)<\/A>|(<A href="#k([0-9]+)">)((?:[^<>]+|<BR\/?>|<P>)*)<\/A>|<A href="((text|note|version|note)[0-9]+\.html)">[^<>]+<\/A>|<IMG src="([^\"]*)"[^<>]*>|<RUBY><RB>(.*?)(?:<\/RB>)?(?:<RP>[^<>]*(?:<\/RP>)?)?<RT>([^<>]*)(?:<\/RT>)?(?:<RP>[^<>]*(?:<\/RP>)?)?<\/RUBY>|<(\/?\w+).*?>|<!--(.*?)-->|<DT>　(.*)&lt;(.*)&gt;|((?:備考.*　朱筆--&lt;朱&gt;|【校訂方針】)[^<>\r\n]*)|(&nbsp;&nbsp;|#?\w+;)|【([^【】]*)】－ *((?:[^<>\n]+|<BR\/?>)+)|(?:当面、和歌は未サポート\n(?:　|&nbsp;)+([""'']?<I>[''""]?)((?:[^<>]+|<\/?A\b[^<>]*>)+?)<BR\/?>\n?(?:　|&nbsp;)+((?:[^<>]+|<\/?A\b[^<>]*>)+?)([""'']?<\/I>[""'']?)(?=<BR\/?>?\n))|(\n(?:<P>|\s|　|&nbsp;)*)|([「」『』])|(&#([0-9]+);)|([^<>&「」『』\n]+)/gi

var xmlDoc;
//var xmlNotesDoc;
//var xmlEiriDoc;

//*********************************************************************************
function newXmlDoc(strRootNode)
{
	var xml = new ActiveXObject("Msxml2.DOMDocument.4.0");
	xml.async = false;
	xml.setProperty("SelectionLanguage", "XPath");
	xml.loadXML(xmlHeader+strRootNode);
	return xml;
}

//*********************************************************************************
function newXmlTextDoc(TextName)
{
	xmlDoc[TextName] = newXmlDoc('<テキスト name="'+TextName+'">\n</テキスト>\n');
}

//*********************************************************************************
function newXmlCommenttDoc(TagName, CommentName, TargetTextName)
{
	xmlDoc[TagName] = xmlDoc[CommentName] = newXmlDoc('<コメント name="'+CommentName+'" for="'+TargetTextName+'">\n</コメント>\n');
}

//*********************************************************************************
function newXmlObjectDoc(ObjectName, path)
{
	var doc = xmlDoc[ObjectName] = newXmlDoc('<オブジェクト name="'+ObjectName+'" >\n</オブジェクト>\n');
	if(path) {
		doc.documentElement.setAttribute("path", path);
	}
}

//*********************************************************************************
function readXmlFile(filename)
{
	var xml = new ActiveXObject("Msxml2.DOMDocument.4.0");
	xml.async = false;
	xml.setProperty("SelectionLanguage", "XPath");
	xml.load(filename);
	return xml;
}

//*********************************************************************************
function xmlInit()
{
	xmlDoc = null;
	xmlDoc = new Array();
	newXmlTextDoc("本文");
	newXmlTextDoc("渋谷栄一訳");
	newXmlTextDoc("与謝野晶子訳");
	newXmlTextDoc("ローマ字版");
	newXmlTextDoc("ひらがな版");
	newXmlCommenttDoc("注釈", "渋谷栄一による注釈", "本文");
	newXmlCommenttDoc("出典", "渋谷栄一による出典", "本文");
	newXmlCommenttDoc("校訂", "渋谷栄一による校訂", "本文");
	newXmlCommenttDoc("和歌", "和歌一覧", "本文");
	newXmlCommenttDoc("詞",   "詞一覧", "本文");
	newXmlCommenttDoc("ルビ", "与謝野晶子訳のルビ", "与謝野晶子訳");
	newXmlObjectDoc("絵入源氏物語の挿絵" /*, xmlImgdir*/);

	xmlDoc["注釈"] = xmlDoc["渋谷栄一による注釈"];
	xmlDoc["出典"] = xmlDoc["渋谷栄一による出典"];
	xmlDoc["校訂"] = xmlDoc["渋谷栄一による校訂"];
	
	//xmlCopyrights = newXmlDoc('<著作権>'+address1+'<BR/>'+address2+'</著作権>\n').documentElement;
}

var wholeFile;

var TextType;

var oVolume;
var Chapter;
var ChapterNo;
var Paragraph;
var ParagraphNo;

var lastEndPos = 0;
var copiedPos = 0;
var srcLineNo = 0;

var flgIgnoreThisLine = false;
var flgIgnoreNextCloseATag = false;

var re_Main_dispatch_traceid = null;

var yosanoRubies = new Array();

var xhtmlEiriSize = readXmlFile(OutputXmlFileNames["絵入源氏物語の挿絵"]+"-size.html");

//*********************************************************************************
function re_Main_dispatch(
	$0,
	foundTitle,       // $1 タイトル。「帖番号 帖名（底本）」の形式
	foundVolumeNo,    // $2 帖番号
	foundVolumeName,  // $3 帖名
	foundSourceBook,  // $4 底本
	foundTextType,    // $5 本文|注釈|現代語訳|与謝野晶子訳|Japanese roman letters
	foundVolumeNameH3,// $6 帖番号 帖名。「01 桐壺」の形式。<H3>タグより取得。
	foundSubTitle,    // $7 サブタイトル。<H3>タグに続く<P>タグより取得。無い帖もある。
	foundWakaYosano,  // $8 与謝野晶子による和歌。与謝野晶子訳にのみ存在する。<P class=wakaAkiko>タグより取得。夕霧の帖以外は１句/帖。与謝野晶子訳では夕霧の帖は２つに分かれているため２句ある。
	foundCopyright,   // $9 著作権情報。<ADDRESS>タグより取得。ほとんどすべてが複数行にまたがっている。
	foundAppearedPersonName,           // $10 登場人物の名前。以下、肩書きまで<DT>タグと<DD>タグより取得。
	foundAppearedPersonFurigana,       // $11 登場人物名の読み方
	foundReferenceWord2AppearedPerson, // $12 登場人物の呼称
	foundAppearedPersonTitle,          // $13 登場人物の肩書きなど
	foundChapterName,       // $14 章名。<H4>タグより取得。
	foundParagraphAnchorNo, // $15 段・出典の段・校訂の段のアンカー番号。以下、段名まで<A name="inNN">タグより取得。
	foundShuttennKoutei,    // $16 (出典|校訂)
	foundParagraphName,     // $17 段名
	foundSourceAnchorNo,    // $18 出典のアンカー番号
	foundSourceName,        // $19 出典名
	foundSourceDescription, // $20 出典の記述
	foundReviceAnchorNo,    // $21 校訂のアンカー番号
	foundReviceName,        // $22 校訂名
	foundReviceDescription, // $23 校訂の記述
	foundReviceReturnID,    //     校訂の戻り
	foundLinkTag2Return4SourceRevice,      // $24 出典・校訂からの戻りのリンク入口
	foundA_href_no_Tag,     //     出典へのリンクタグ
	foundA_href_noNN,       // $25 出典へのリンクで、リンク先の出典のアンカー番号
	foundShuttenMidashi,    // $26 出典へのリンクで、出典見出し。改行を含んでいることがある。
	foundA_href_k_Tag,      //     校訂へのリンクタグ
	foundA_href_kNN,        // $27 校訂へのリンクで、リンク先の校訂のアンカー番号
	foundKouteiMidashi,     // $28 校訂へのリンクで、校訂見出し。改行を含んでいることがある。
	foundLink2OtherText,    //     (text|note|version|note)[0-9]+\.html
	foundLinkTextType,      //     text|note|version|note
	foundIMG_src,           // $29 挿絵のURL。<IMG src="URL">タグから抽出。
	foundRuby_RB,
	foundRuby_RT,
	foundOtherTag,          // $30 その他のHTMLタグが見つかったとき、そのタグ名。終了タグの場合'/'で始まる。その他のタグはタグ名の英数字部分のみ。
	foundHtmlComment,       // $31 HTMLコメント
	foundReferenceWord,              // 呼称
	foundReferenceWordPronunciation, // 呼称の読み
	foundReviceLegendEtc,      //     校訂の凡例、校訂方針
	foundSpecialChar,       // $32 特殊文字
	foundNotesKeyword,      // $33 注釈見出し
	foundNotesDescription,  // $34 注釈の記述
	foundWakaKaminoku,      // $35 和歌の上の句(ローマ字版)
	foundWakaShimonoku,     // $36 和歌の下の句(ローマ字版)
	foundNL,                // 上記のいずれにも含まれない改行を検出したことをあらわす。
	foundQuote4Serif,       // 引用符(「」『』)
	foundUniCodeEsc ,       // &#nnnnn;
	foundUniCode,           // &#nnnnn;のnnnnn部分(10進数)
	foundText,              // $37 テキスト
	pos)
{
	//copiedPos += lastEndPos - pos;
	if(pos - lastEndPos<0) stop;
	copiedPos += pos - lastEndPos;
	var ret="";
	if(foundNL) {
		//  foundNL:         $1 NL。他のいずれにも含まれない改行を検出したことをあらわす。
		ret = NL_Proc(copiedPos);
	}
	else if(foundVolumeName) {
		//帖名の設定
		if(Paragraph) stop;
		if(foundVolumeNo && oVolume.no!=foundVolumeNo) stop;
		//re_Main_dispatch_traceid = foundVolumeNo+" "+foundVolumeName+" "+TextType+" メインパーサ";
		//trace(re_Main_dispatch_traceid);
		//ret = '<テキスト name="'+TextType+'">\n'
		//    + '<帖 no="'+foundVolumeNo+'" name="'+foundVolumeName+'">';
		switch(TextType) {
		case "本文":
			oVolume.name       = foundVolumeName;
			oVolume.title      = foundVolumeNo+" "+foundVolumeName;
			oVolume.sourceVolume = foundSourceBook;
			//ret = ret + '\n<底本>'+oVolume.sourceVolume+'</底本>';
			break;
		case "ローマ字版":
			oVolume.title2 = foundVolumeNo+" "+foundVolumeName;
			break;
		case "与謝野晶子訳":
			break;
		default:
			if(oVolume.title=="") {
				oVolume.name       = foundVolumeName;
				oVolume.title      = foundVolumeNo+" "+foundVolumeName;
			}
			else if(oVolume.title!=foundVolumeNo+" "+foundVolumeName) {
				alert(TextType+":"+oVolume.title+":"+foundVolumeNo+" "+foundVolumeName);
				stop;
			}
			break;
		}
		if(xmlDoc[TextType]) {
			oVolume.xml = xmlDoc[TextType].createElement("帖");
			oVolume.xml.setAttribute("no",    oVolume.no);
			oVolume.xml.setAttribute("name",  oVolume.name);
			oVolume.xml.setAttribute("title", oVolume.title);
			oVolume.xml.setAttribute("srcLineNo", srcLineNo);
			oVolume.xml.text = "\n";
			xmlDoc[TextType].documentElement.appendChild(oVolume.xml);
		}
		if(TextType=="本文") {
			var elem = xmlDoc[TextType].createElement("底本");
			    elem.text = foundSourceBook;
			oVolume.xml.appendChild(elem);
		}
		ChapterNo = 0
	}
	else if(foundVolumeNameH3) {
		//  foundVolumeNameH3: $6 帖番号 帖名。「01 桐壺」の形式。<H3>タグより取得。
		//  foundSubTitle:   $7 サブタイトル。<H3>タグに続く<P>タグより取得。
		//帖名-2の設定
		if(Paragraph) stop;
		if(foundSubTitle) {
			switch(TextType) {
			case "本文":
				oVolume.subtitle = foundSubTitle;
				//ret = '\n<副題>'+oVolume.subtitle+'</副題>';
				break;
			case "ローマ字版":
				oVolume.subtitle2 = foundSubTitle;
				//ret = '\n<副題>'+oVolume.subtitle2+'</副題>';
				break;
			default:
				break;
			}
			if(xmlDoc[TextType] && xmlDoc[TextType].documentElement.tagName=="テキスト") {
				var elem = xmlDoc[TextType].createElement("副題");
				    elem.text = foundSubTitle;
				oVolume.xml.appendChild(elem);
				oVolume.xml.appendChild(xmlDoc[TextType].createTextNode("\n"));
			}
		}
	}
	else if(foundWakaYosano) {
		//  foundWakaYosano:  $7 与謝野晶子による和歌。与謝野晶子訳にのみ存在する。<P class=wakaAkiko>タグより取得。
		//  夕霧の帖以外は１句/帖。与謝野晶子訳では夕霧の帖は２つに分かれているため２句ある。(未対応)
		oVolume.wakaAkiko = foundWakaYosano;
		//if(oVolume.xml) {
		//	oVolume.xml.appendChild(/*与謝野晶子による和歌のXMLオブジェクト*/)
		//}
	}
	else if(foundCopyright) {
		//  foundCopyright:    $8 著作権情報。<ADDRESS>タグより取得。ほとんどすべてが複数行にまたがっている。
		//alert("foundCopyright["+TextType+"] = " + foundCopyright);
		if(Paragraph) stop;
		foundCopyright = foundCopyright.replace(/\s+|(\s|<BR\/?>)+$/gi, " ").replace(/<BR\/?>/gi, "<BR/>");
		switch(TextType) {
		case "ローマ字版":
		case "本文":
		case "注釈":
		case "渋谷栄一訳":
			if(result=/^((?:.*\n)*?.*?)<BR\/?>\s*(Picture .*?)$/i.exec(foundCopyright),result) {
				oVolume.address[TextType] = result[1].replace("roman letters by Eiichi Shibuya","roman letters<BR/>by Eiichi Shibuya");
				oVolume.address["挿絵"] = "挿絵：山本春正　絵入源氏物語：慶安3年(1650年)";
				oVolume.address["IMG"] =  result[2];
			}
			else {
				if(TextType=="ローマ字版") stop
				oVolume.address[TextType] = foundCopyright;
			}
			break;
		case "与謝野晶子訳":
			oVolume.address[TextType] = Copyright4TransYosano[oVolume.no*1].Copyright;
		}
		if(xmlDoc[TextType]) {
			//var cdata = xmlDoc[TextType].createCDATASection(oVolume.address[TextType]);
			//var elem = xmlDoc[TextType].createElement("著作権");
			//elem.appendChild(cdata);
			var elem = newXmlDoc("<著作権>"+oVolume.address[TextType].replace(/\bnowrap\b/g, "nowrap='true'")+"</著作権>")
			oVolume.xml.appendChild(elem.documentElement);
			oVolume.xml.appendChild(elem.createTextNode("\n"));
		}
		//ret="\n<著作権>"+oVolume.address[TextType]+"</著作権>"
	}
	else if(foundAppearedPersonName) {
		//  foundAppearedPersonName,           // $10 登場人物の名前。以下、肩書きまで<DT>タグと<DD>タグより取得。
		//  foundAppearedPersonFurigana,       // $11 登場人物名の読み方
		//  foundReferenceWord2AppearedPerson, // $12 登場人物の呼称
		//  foundAppearedPersonTitle,          // $13 登場人物の肩書きなど
		if(Paragraph) stop;
		//myReportWriter.writeln("<LI>" + TextType + " 登場人物:"+foundAppearedPersonName+"("+foundAppearedPersonFurigana+") : 呼称---"+ foundReferenceWord2AppearedPerson + " (" + foundAppearedPersonTitle+ ")</LI>");
	} 
	else if(foundChapterName) {
		//  foundChapterName: $14 章名。<H4>タグより取得。
		if(Paragraph != null) {
			//copiedPos = Paragraph.endpos[TextType];
			Paragraph = null;
		}
		//章の開始
		Chapter = null;
		ChapterNo++;
		ParagraphNo=0;
		Paragraph = null;
		if(ChapterNo==oVolume.Chapters.length || oVolume.Chapters.length==0) {
			if(ChapterNo==0) stop
			Chapter = new Array();
			Chapter.no = ChapterNo;
			Chapter.id = /*oVolume.no + "." +*/ ChapterNo;
			Chapter.name = foundChapterName;
			Chapter.name2 = "";
			Chapter.Paragraphs = new Array();
			oVolume.Chapters[ChapterNo] = Chapter;
		}
		else if(ChapterNo<oVolume.Chapters.length) {
			Chapter = oVolume.Chapters[ChapterNo];
			//章名の設定
			switch(TextType) {
			case "本文":
				Chapter.name = foundChapterName;
				break;
			case "ローマ字版":
				foundChapterName = foundChapterName.replace(/(?:&nbsp;| |<I>|<\/I>)+/gi, " ");
				Chapter.name2 = foundChapterName;
				break;
			default:
				if(Chapter.name=="") {
					Chapter.name = foundChapterName;
				}
				break;
			}
		}
		else {
			Chapter = null;
		}
		if(Chapter != null) {
			//ret=(ChapterNo==1?"":"\n</段>\n</章>")+"\n<章 no=\""+ChapterNo+"\" name=\""+foundChapterName+"\">"
			ret="\n<章 no=\""+ChapterNo+"\" name=\""+foundChapterName+"\"/>"
			if(xmlDoc[TextType]) {
				Chapter.xml = xmlDoc[TextType].createElement("章");
				Chapter.xml.text = "\n";
				Chapter.xml.setAttribute("no", Chapter.no);
				Chapter.xml.setAttribute("id", Chapter.id);
				Chapter.xml.setAttribute("name", Chapter.name);
				Chapter.xml.setAttribute("srcLineNo", srcLineNo);
				oVolume.xml.appendChild(Chapter.xml);
				
			}
		}
		//docProgress.write(oVolume.title + " " + TextType + " " + result[1] + "<br>\n")
	}
	else if(foundParagraphAnchorNo) {
		//  foundParagraphAnchorNo:    $15 段・出典・校訂のアンカー番号。以下、段名まで<A name="inNN">タグより取得。
		//  foundShuttennKoutei: $16 (出典|校訂)
		//  foundParagraphName:  $17 段名
		if(foundParagraphName) {
			if(foundParagraphName=="") debug.debug();
			//if(foundParagraphAnchorNo=="12") debug.debug();
			if(Paragraph != null) {
				//copiedPos = Paragraph.endpos[TextType];
				Paragraph = null;
			}
			//段のアンカー⇒段の開始
			ParagraphNo++;
			if(ParagraphNo==Chapter.Paragraphs.length || Chapter.Paragraphs.length==0) {
				Paragraph = new Array();
				Paragraph.no = ParagraphNo
				Paragraph.id = Chapter.id+"."+ParagraphNo;
				Paragraph.hrefid = foundParagraphAnchorNo;
				Paragraph.name = foundParagraphName;
				Paragraph.name2 = "";
				Paragraph.pos = new Array();
				Paragraph.endpos = new Array();
				Paragraph.LineNo = 0; // 段内LineNo。段の先頭には改行があるので、LineNoは実質１始まりになる。
				oVolume.cntParagraphs++;
				Chapter.Paragraphs[ParagraphNo] = Paragraph;
			}
			else if(ParagraphNo < Chapter.Paragraphs.length) {
				Paragraph = Chapter.Paragraphs[ParagraphNo];
				if(Paragraph==null) stop;
	        	//if(Paragraph.id=="1.3" && TextType=="与謝野晶子訳") stop
				Paragraph.LineNo = 0; // 段内LineNo。段の先頭には改行があるので、LineNoは実質１始まりになる。
				if(Paragraph.hrefid != foundParagraphAnchorNo) debug.debug();
				//段名の設定
				switch(TextType) {
				case "本文":
					Paragraph.name = foundParagraphName;
					break;
				case "ローマ字版":
					foundParagraphName = foundParagraphName.replace(/(?:&nbsp;| |<I>|<\/I>)+/gi, " ");
					Paragraph.name2 = foundParagraphName;
					break;
				default:
					if(Paragraph.name=="") {
						Paragraph.name = foundParagraphName;
					}
					break;
				}
			}
			else {
				Paragraph = null;
			}
			if(Paragraph != null) {
				//trace(re_Main_dispatch_traceid+" "+Paragraph.id+"段");
				//ret=(ParagraphNo==1?"":"\n</段>")+"\n<段 no=\""+ParagraphNo+"\" name=\""+foundParagraphName+"\">"
				ret="\n<段 no=\""+ParagraphNo+"\" name=\""+foundParagraphName+"\"/>"
				Paragraph.pos[TextType] = copiedPos+ret.length;
				if(Paragraph.pos[TextType]<0 || Paragraph.pos[TextType]<copiedPos) stop;
				if(xmlDoc[TextType]) {
					Paragraph.xml = xmlDoc[TextType].createElement("段");
					Paragraph.xml.text = "\n";
					Paragraph.xml.setAttribute("no", Paragraph.no);
					Paragraph.xml.setAttribute("id", Paragraph.id);
					Paragraph.xml.setAttribute("name", Paragraph.name);
					Paragraph.xml.setAttribute("srcLineNo", srcLineNo);
					Chapter.xml.appendChild(Paragraph.xml);
					Chapter.xml.appendChild(xmlDoc[TextType].createTextNode("\n"));
				}
				
			}
		}
		else {
			//出典・校訂の段アンカー⇒無視
			if(Paragraph != null) {
				//trace(re_Main_dispatch_traceid+" "+foundShuttennKoutei);
				Paragraph = null;
				//ret = "\n</段>\n</章>\n</帖>\n</テキスト>\n";
			}
		}
	}
	else if(foundA_href_noNN && foundA_href_noNN!="") {
		//  foundA_href_noNN:    $25 出典へのリンクで、リンク先の出典のアンカー番号
		//  foundShuttenMidashi: $26 出典へのリンクで、出典見出し。改行や校訂へのリンクを含んでいることがある。
		//出典へのリンクを抽出
		if(Paragraph==null) stop;
		var src = new Keyword("出典", foundA_href_noNN, foundShuttenMidashi, copiedPos);
		var ret = "";
		var from = 0;
		var re = /<A href=[""]#k([0-9]+)[""]>([^<>]*)<\/A>|([「」『』])|((?:[ ]|<BR\/?>|<P>)*[\n](?:<BR\/?>|<P>|[ 　\n])*)/gi
		var result;
		while(result=re.exec(foundShuttenMidashi),result) {
			var tmp
			if(result[1] && result[1]!="") {
				var rev = new Keyword("校訂", result[1], result[2], copiedPos+result.index);
				tmp = result[2];
			}
			else if(result[3] && result[3]!="") {
				Quote4Serif_Proc(result[3], copiedPos+result.index);
				tmp = result[3];
			}
			else if(result[4] && result[4]!="") {
				tmp = NL_Proc(copiedPos+result.index);
			}
			ret = ret + foundShuttenMidashi.substring(from, result.index) + tmp;
			from = result.index + result[0].length;
		}
		ret = ret + foundShuttenMidashi.substr(from);
	}
	else if(foundA_href_kNN && foundA_href_kNN!="") {
		//  foundA_href_kNN:    $27 校訂へのリンクで、リンク先の校訂のアンカー番号
		//  foundKouteiMidashi: $28 校訂へのリンクで、校訂見出し。改行を含んでいることがある。
		//校訂へのリンクを抽出
		if(Paragraph==null) stop;
		var rev = new Keyword("校訂", foundA_href_kNN, foundKouteiMidashi, copiedPos);
		var ret = "";
		var from = 0;
		var re = /([「」『』])|((?:\n|<BR\/?>|<P>)+[ 　]*)/gi;
		var result;
		//if(foundKouteiMidashi.indexOf("\n")>=0) stop
		while(result=re.exec(foundKouteiMidashi),result) {
			var tmp
			
			if(result[1] && result[1]!="") {
				Quote4Serif_Proc(result[1], copiedPos+ret.length+result.index-from);
				tmp = result[1];
			}
			else if(result[2] && result[2]!="") {
				tmp = NL_Proc(copiedPos+ret.length+result.index-from);
			}
			ret = ret + foundKouteiMidashi.substring(from, result.index) + tmp;
			from = result.index + result[0].length;
		}
		ret = ret + foundKouteiMidashi.substr(from);
	}
	else if(foundLinkTag2Return4SourceRevice && foundLinkTag2Return4SourceRevice!="") {
		//  foundLinkTag2Return4SourceRevice: $24 出典・校訂からの戻りのリンク入口
		if(Paragraph==null) stop;
		flgIgnoreNextCloseATag = true;
	}
	else if(foundSourceAnchorNo && foundSourceAnchorNo!="") {
		//  foundSourceAnchorNo:    $18 出典のアンカー番号
		//  foundSourceName:        $19 出典名
		//  foundSourceDescription: $20 出典の記述
		//出典の記述を抽出
		if(Paragraph) stop;
		var src = oVolume.Keywords["出典"+foundSourceAnchorNo];
		//if(src==null) stop
		if(src) {
  		src.name  = foundSourceName;
  		//src.pDescription = new Description(src, 
  		src.description = foundSourceDescription.replace(/([^（）]+)（([^（）]+)）(?:\s|<BR\/?>|　)*/gi, "$1<文献>$2</文献>")
  			                             //.replace(/<ruby><rb>([^<>]*)(?:<\/rb>)?(?:<rp>[^<>]*(?:<\/rp>)?)?<rt>([^<>]*)(?:<\/rt>)?(?:<rp>[^<>]*(?:<\/rp>)?)?<\/ruby>/gi, "&lt;RUBY&gt;&lt;RB&gt;$1&lt;/RB&gt;&lt;RP&gt;(&lt;/RP&gt;&lt;RT&gt;$2&lt;/RT&gt;&lt;RP&gt;)&lt;/RP&gt;&lt;/RUBY&gt;");
  			                             .replace(/<ruby><rb>([^<>]*)(?:<\/rb>)?(?:<rp>[^<>]*(?:<\/rp>)?)?<rt>([^<>]*)(?:<\/rt>)?(?:<rp>[^<>]*(?:<\/rp>)?)?<\/ruby>/gi, "$1($2)");
  		src.srcLineNo = srcLineNo;
		}

	}
	else if(foundReviceAnchorNo && foundReviceAnchorNo!="") {
		//  foundReviceAnchorNo,     // $21 校訂のアンカー番号
		//  foundReviceName,         // $22 校訂名
		//  foundReviceDescription,  // $23 校訂の記述
		//  foundReviceReturnID      //     校訂の戻り
		//校訂の記述を抽出
		if(Paragraph) stop;
		var rev = oVolume.Keywords["校訂"+foundReviceAnchorNo];
		var kwKoutei = foundReviceDescription.substr(0,foundReviceDescription.indexOf("--"));
		if(rev==null) {
			// リンクされなかった校訂
			if(foundReviceReturnID.substr(0,2)=="te") {
				// 出典と競合したためリンクされなかった校訂
				var nodeCompetingSources = oVolume.Keywords["出典"+foundReviceReturnID.substr(2)]; // 競合した出典ノード
				if(nodeCompetingSources==null || nodeCompetingSources.keyword==null || nodeCompetingSources.pos==null) stop
				myReportWriter.writeln("<LI>校訂"+foundReviceAnchorNo + "：出典"+nodeCompetingSources.no+"("+nodeCompetingSources.keyword+")と競合したためリンクされなかった校訂("+foundReviceDescription+")</LI>");
				if(Paragraph) stop
				Paragraph = nodeCompetingSources.Paragraph;
				rev = new Keyword("校訂", foundReviceAnchorNo, nodeCompetingSources.keyword, null); // 競合したためリンクされなかった校訂ノード
				rev.pos    = nodeCompetingSources.pos;
				rev.endpos = nodeCompetingSources.endpos;
				rev.lineid = nodeCompetingSources.lineid;
				rev.lineno = nodeCompetingSources.lineno;
				Paragraph = null;
			}
			else {
				myReportWriter.writeln("<LI><FONT color='red'>校訂"+foundReviceAnchorNo + "：リンクされない孤立した校訂("+foundReviceDescription+")</FONT></LI>");
			}
		}
		/*else {
			if(rev.keyword != kwKoutei) {
				myReportWriter.writeln("<LI>校訂"+foundReviceAnchorNo + "：キーワード不一致(【"+rev.keyword+"】："+foundReviceDescription+")</LI>");
			}
		}*/
		if(rev) {
			rev.name = foundReviceName;
			rev.description = foundReviceDescription;
			rev.srcLineNo = srcLineNo;
		}
	}
	else if(foundNotesKeyword && foundNotesKeyword!="") {
		//  foundNotesKeyword:      $33 注釈見出し
		//  foundNotesDescription:  $34 注釈の記述
		//注釈の記述を抽出
		if(Paragraph==null) stop;
		if(oVolume.cnt["注釈#"]==null) oVolume.cnt["注釈#"]=0;
		oVolume.cnt["注釈#"] ++;
		var noteno = oVolume.cnt["注釈#"];
		var notekw = new Keyword("注釈", noteno, foundNotesKeyword, null);
		notekw.description = foundNotesDescription.replace(/(?:<[^<>]*>|\s)+/g, " ");
		notekw.srcLineNo = srcLineNo;
	}
	else if(foundLink2OtherText ) {
		// ファイル末尾のリンク
		if(Paragraph != null) {
			copiedPos = Paragraph.endpos[TextType];
			Paragraph = null;
			//ret = "\n</段>\n</章>\n</帖>\n</テキスト>\n";
		}
	}
	else if(foundIMG_src) {
		//  foundIMG_src: $27 挿絵のURL。<IMG src="URL">タグから抽出。
		//挿絵へのリンクを抽出
		if(Paragraph==null || Paragraph.LineNo<=0) stop;
		if(oVolume.cnt.Illustrations==null) oVolume.cnt.Illustrations = 1;
		else oVolume.cnt.Illustrations = oVolume.cnt.Illustrations + 1;
		{	var xmldoc = xmlDoc["絵入源氏物語の挿絵"];
			var nodeIllustration = newXmlNode(xmldoc, "挿絵")
				nodeIllustration.setAttribute("no", oVolume.cnt.Illustrations);
				
			//var IllustrationCDATA = xmldoc.createCDATASection('<IMG src="'+xmlImgdir+foundIMG_src+'"/>\n')
			//	Illustration.appendChild(IllustrationCDATA);
			var xmlNode = xmldoc.createElement("挿入");
				xmlNode.text = "\n";
				xmlNode.setAttribute("行", Paragraph.LineNo);
				nodeIllustration.appendChild(xmlNode);
				nodeIllustration.appendChild(xmldoc.createTextNode("\n"));
			var path = "/" + OutputXmlFileNames["絵入源氏物語の挿絵"].substr(RootDirPath.length).replace(/[^\/]*$/, "");
			var xmlNodeEiriSize = xhtmlEiriSize.documentElement.selectSingleNode('//IMG[@src="'+foundIMG_src+'"]');
			var xmlNodeIMG = xmldoc.createElement("IMG")
				xmlNodeIMG.setAttribute("src", path + foundIMG_src);
				xmlNodeIMG.setAttribute("width", xmlNodeEiriSize.getAttribute("width"));
				xmlNodeIMG.setAttribute("height", xmlNodeEiriSize.getAttribute("height"));
				xmlNode.appendChild(xmlNodeIMG);
				xmlNode.appendChild(xmldoc.createTextNode("\n"));
		}
		flgIgnoreThisLine = true;
	}
	else if(foundRuby_RB) {
		// ルビ
		switch(TextType) {
		//case "本文":
		case "注釈":
			//ret = "<RUBY><RB>"+foundRuby_RB+"</RB><RP>（</RP><RT>"+foundRuby_RT+"</RT><RP>）</RP></RUBY>";
			ret = foundRuby_RB;
			myReportWriter.writeln("<LI>" + TextType + " 第"+ChapterNo+"章 第"+ParagraphNo+"段：RUBYタグ=("+$0+") ret=("+ret+")</LI>");
			break;
		case "与謝野晶子訳":
			if(oVolume.cnt.Ruby4Yosano==null) oVolume.cnt.Ruby4Yosano = 1;
			else oVolume.cnt.Ruby4Yosano = oVolume.cnt.Ruby4Yosano + 1;

			{	var xmldoc = xmlDoc["与謝野晶子訳のルビ"];
				var ColumnNo = copiedPos-Paragraph.pos[TextType]-Paragraph.linePos[TextType][Paragraph.LineNo];
				var nodeRuby; // ルビ
					if(false) {
						ret = $0;
					}
					else {
						if(foundRuby_RB.indexOf("&#")<0 &&
						   foundRuby_RB.indexOf("<") <0  )
						{
							ret = foundRuby_RB;
							//ret = "<RUBY><RB>"+foundRuby_RB+"</RB><RP>（</RP><RT>"+foundRuby_RT+"</RT><RP>）</RP></RUBY>";
						}
						else {
							//alert("デバッグ　与謝野晶子訳の特殊RUBYタグ：<RUBY><RB>"+foundRuby_RB+"</RB><RT>"+foundRuby_RT+"<RT></RUBY>\n"+$0);
							// 第3水準漢字(UNICODE文字)、コメント、返り点などがある。
							var PosInRubyAftConv = 0;        // 変換後ルビ内位置
							var PrevEndPosInRubyBefConv = 0; // 変換前ルビ内前回末尾位置
							ret = foundRuby_RB
								.replace(/&#([0-9]+);|<!--(.+?)-->|<SMALL><SUB>(.)<\/SUB><\/SMALL>/g,
									function($0, UniCode,
										Comment,  // コメント
										Kaeriten, // 返り点
										posInRuby) {
										PosInRubyAftConv = PosInRubyAftConv + posInRuby - PrevEndPosInRubyBefConv;
										PrevEndPosInRubyBefConv = posInRuby + $0.length;
										var str;
										if(UniCode) {
											str = String.fromCharCode(UniCode*1);
										}
										else if(Comment) {
											str = "";
										}
										else if(Kaeriten) {
											str = "";
										}
										else stop;
										PosInRubyAftConv = PosInRubyAftConv+str.length; 
										return str;
									});
							if(ret.indexOf("&#")>=0 ||
							   ret.indexOf("<") >=0  ) stop;
						}
					}
					nodeRuby = newXmlNode(xmldoc, "ルビ")
					nodeRuby.setAttribute("no", oVolume.cnt.Ruby4Yosano);
					nodeRuby.setAttribute("keyword", ret);
					nodeRuby.text = foundRuby_RT;
				var nodeStartRuby = xmldoc.createElement("開始")
					nodeStartRuby.setAttribute("行", Paragraph.LineNo);
					nodeStartRuby.setAttribute("桁", ColumnNo);
					nodeRuby.appendChild(nodeStartRuby);
				var nodeEndRuby = xmldoc.createElement("終了")
					nodeEndRuby.setAttribute("行", Paragraph.LineNo);
					nodeEndRuby.setAttribute("桁", ColumnNo+ret.length);
					nodeRuby.appendChild(nodeEndRuby);
			}
			break;
		default:
			alert(oVolume.title+" 第"+ChapterNo+"章 第"+ParagraphNo+"段 第"+Paragraph.LineNo+"行 unknown TextType("+TextType+") for RUBY tag("+$0+")");
		}
	}
	else if(foundOtherTag) {
		//  foundOtherTag:    $30 その他のHTMLタグが見つかったとき、そのタグ名。終了タグの場合'/'で始まる。その他のタグはタグ名の英数字部分のみ。
		if(Paragraph) {
			switch(foundOtherTag) {
			case "span":
			case "/span":
				if(TextType!="与謝野晶子訳") stop;
				break;
			case "I":
				if(TextType!="ローマ字版") stop;
				ret = "〔";
				break;
			case "/I":
				if(TextType!="ローマ字版") stop;
				ret = "〕";
				break;
			case "BR":
			case "br":
				ret = "<BR/>";
				break;
			case "/BODY":
				trace(re_Main_dispatch_traceid+" 終了");
			case "HR":
				if(Paragraph != null) {
					copiedPos = Paragraph.endpos[TextType];
					Paragraph = null;
					ret = "\n</段>\n</章>\n</oVolume>\n</テキスト>\n";
				}
				break;
			case "/A":
				if(flgIgnoreNextCloseATag) {
					flgIgnoreNextCloseATag = false;
					break;
				}
			default:
				stop;
				break;
			}
		}
	}
	else if(foundHtmlComment) {
		//  foundHtmlComment: $31 HTMLコメント
		if(TextType=="与謝野晶子訳" && foundHtmlComment=="空行")     ;
		else {
			myReportWriter.writeln("<LI>" + TextType + " 第"+ChapterNo+"章 第"+ParagraphNo+"段 第"+Paragraph.LineNo+"行：foundHtmlComment=("+foundHtmlComment+")</LI>");
		}
	}
	else if(foundReferenceWord) {
		// 呼称、呼称の読み⇒無視
		myReportWriter.writeln("<LI>" + TextType + " 第"+ChapterNo+"章 第"+ParagraphNo+"段 第"+Paragraph.LineNo+"行：呼称:"+foundReferenceWord+"("+foundReferenceWordPronunciation+")</LI>");
	}
	else if(foundReviceLegendEtc) {
		// 校訂の凡例、校訂方針⇒無視
		//myReportWriter.writeln("<LI>" + TextType + " 第"+ChapterNo+"章 第"+ParagraphNo+"段：校訂の凡例、校訂方針:"+foundReviceLegendEtc+")</LI>");
	}
	else if(foundSpecialChar) {
		//  foundSpecialChar: $32 特殊文字
		//ret = $0;
		if(TextType=="ローマ字版" && foundSpecialChar=="&nbsp;&nbsp;")     ;
		else {
			myReportWriter.writeln("<LI>" + TextType + " 第"+ChapterNo+"章 第"+ParagraphNo+"段 第"+Paragraph.LineNo+"行：特殊文字("+foundSpecialChar+")</LI>");
		}
	}
	else if(foundWakaKaminoku) {
		//  foundWakaKaminoku,      $35 和歌の上の句(ローマ字版)
		//  foundWakaShimonoku,     $36 和歌の下の句(ローマ字版)
		myReportWriter.writeln("<LI>" + TextType + " 第"+ChapterNo+"章 第"+ParagraphNo+"段 第"+Paragraph.LineNo+"行：foundWakaKaminoku="+foundWakaKaminoku+" -- foundWakaShimonoku=" + foundWakaShimonoku +")</LI>");
		stop
		if(Paragraph==null) stop;
		if(TextType!="ローマ字版") stop;
		if(oVolume.cnt["和歌#"]==null) oVolume.cnt["和歌#"]=0;
		oVolume.cnt["和歌#"]++;
		var wakano = oVolume.cnt["和歌#"];
		var CurrWaka = new Keyword("和歌", wakano, null, null);
		myReportWriter.writeln("<LI>和歌"+wakano+" "+Paragraph.currLineid + " ( " + Paragraph.LineNo + ") : " + foundWakaKaminoku + " -- " + foundWakaShimonoku + "</LI>");
		/*var i,  re;
		for(i=0,re=/\n(?:<P>|\s|　|&nbsp;)* /g; result=re.exec($0); i++) {
			ret = ret + NL_Proc(copiedPos+ret.length);
			if(i==0) {
				CurrWaka.lineid = Paragraph.currLineid;
				CurrWaka.lineno = Paragraph.LineNo;
				ret = ret + / *"<和歌/>" +* / foundWakaPreKaminoku.replace(/<I>/gi,"") + foundWakaKaminoku;
			}
			else if(i==1) {
				ret = ret + foundWakaShimonoku + foundWakaPostShimonoku.replace(/<\/I>/gi,"");
			}
			else stop
		}*/
	}
	else if(foundQuote4Serif) {
		if(Paragraph) {
			if(TextType=="本文") {
				Quote4Serif_Proc(foundQuote4Serif, copiedPos);
			}
			ret = $0;
		}
	}
	else if(foundUniCode) {
		ret = unescape("%u"+(foundUniCode*1).toString(16));
		//ret = $0;
	}
	else if(foundText) {
		if(Paragraph) {
			ret = $0;
		}
	}
	lastEndPos = pos + $0.length;
	copiedPos += ret.length;
	$0.replace(/\n/g, function() { srcLineNo++; return null;});
	return ret;
}

//*********************************************************************************
function postParser(text)
{
	if(xmlDoc[TextType]==null) return;
	var no = oVolume.no;
	
	for(ChapterNo=1; ChapterNo<oVolume.Chapters.length; ++ChapterNo)
	{
		Chapter = oVolume.Chapters[ChapterNo];
		if(Chapter==null) continue;
		for(ParagraphNo=1; ParagraphNo < Chapter.Paragraphs.length; ++ParagraphNo)
		{
			Paragraph = Chapter.Paragraphs[ParagraphNo];
			if(Paragraph==null || Paragraph.linePos[TextType]==null) continue;
			for(LineNo=1; LineNo < Paragraph.linePos[TextType].length-1; ++LineNo)
			{
				{	var xmldoc = xmlDoc[TextType];
					var xmlNodeLine = xmldoc.createElement("行");
						xmlNodeLine.setAttribute("no", LineNo);
						xmlNodeLine.setAttribute("id", Paragraph.id + "." + LineNo);
						xmlNodeLine.setAttribute("srcLineNo", Paragraph.srcLineNo[TextType][LineNo]);
					var xmlParagraph = getXmlParagraph(xmldoc)
					xmlParagraph.appendChild(xmlNodeLine);
					xmlParagraph.appendChild(xmldoc.createTextNode("\n"));

					var text = oVolume.wholeText[TextType].substring(
						Paragraph.pos[TextType]+Paragraph.linePos[TextType][LineNo],
						Paragraph.pos[TextType]+Paragraph.lineEndPos[TextType][LineNo]);
					text = text.replace(/^(?:[\s　]|<[^<>]*>)+|(?:[\s　]|<[^<>]*>)+$/g, "");
					if(true) {
	                    var reBR = /<BR\/?>/g;
						for(var lastpos = 0; matched=reBR.exec(text);
						        lastpos =    matched.lastIndex)
						{
							var str = text.substring(lastpos, matched.index);
							xmlNodeLine.appendChild(xmldoc.createTextNode(str));
							xmlNodeLine.appendChild(xmldoc.createElement("BR"));
						}
					}
					else { // なぜか、うまくいかない
						//              /                                 1                              2                  3
						var reXmlTags = /<BR\/?>|<RUBY>|<RB>|<SMALL><SUB>(.+)<\/SUB><\/SMALL>|<\/RB>|<RT>([^<>]+)<\/RT>|<RP>([^<>]+)<\/RP>|<\/RUBY>/gi;
						var xmlNodeToAppend = xmlNodeLine;
						var nodeRUBY = null;
						var bRB = false;
						for(var lastpos = 0; matched=reXmlTags.exec(text);
						        lastpos =    matched.lastIndex)
						{
							function MyDebugPopup(msg) {
								alert(msg + " " + ChapterNo + "." + ParagraphNo + "." + LineNo + ": bRB="+ bRB + (nodeRUBY ? " nodeRUBY=" + nodeRUBY.tagName : "") + "\ntext[0..][lastpos..matched.index][..matched.lastIndex][..]=\n[0..]["+lastpos+".."+matched.index+"][.."+matched.lastIndex+"][..]=["+text.substring(0, lastpos)+"]["+text.substring(lastpos, matched.index)+"]["+text.substring(matched.index,matched.lastIndex)+"]["+text.substr(matched.lastIndex)+"]");
							}
							if(lastpos < matched.index) {
								var str = text.substring(lastpos, matched.index);
								xmlNodeToAppend.appendChild(xmldoc.createTextNode(str));
							}
							switch(matched[0]) {
							case "<BR>":
							case "<BR/>":
								xmlNodeToAppend.appendChild(xmldoc.createElement("BR"));
								break;
							case "<RUBY>":
								if(nodeRUBY) WshShell.Popup("デバッグ");
								nodeRUBY = xmldoc.createElement("ルビ");
								xmlNodeToAppend = nodeRUBY; 
								break;
							case "</RUBY>":
								if( ! (nodeRUBY && nodeRUBY.tagName == "ルビ" && !bRB)) MyDebugPopup("デバッグ");
								nodeRUBY = null;
								xmlNodeToAppend = xmlNodeLine;
								break;
							case "<RB>":
								if( ! (nodeRUBY && nodeRUBY.tagName == "ルビ" && !bRB)) MyDebugPopup("デバッグ");
								bRB = true;
								break;
							case "</RB>":
								if( ! (nodeRUBY && nodeRUBY.tagName == "ルビ" && bRB)) MyDebugPopup("デバッグ");
								var str = text.substring(lastpos, matched.index);
								xmlNodeToAppend.appendChild(xmldoc.createTextNode(str));
								bRB = false;
								break;
							default:
								if( ! (nodeRUBY && nodeRUBY.tagName == "ルビ" && !bRB)) MyDebugPopup("デバッグ");
								if(matched[1]) { // <SMALL><SUB>(.+)<\/SUB><\/SMALL>
									var nodeSUB = xmldoc.createElement("SUB");
										nodeSUB.appendChild(xmldoc.createTextNode(matched[1]+""));
									xmlNodeToAppend.appendChild(nodeSUB);
								}
								else if(matched[2]) { // <RT>([^<>]+)<\/RT>
									nodeRUBY.setAttribute("読み", matched[2]+"");
								}
								else if(matched[3]) { // <RP>([^<>]+)<\/RP>
									// NOP
								}
								else  MyDebugPopup("デバッグ");
							}
						}
					}
					str = text.substr(lastpos);
					xmlNodeLine.appendChild(xmlDoc[TextType].createTextNode(str));
				}
			}
		}
	}
}

//*********************************************************************************
function getXmlParagraph(xmldoc)
{
	var xmlVolume = xmldoc.documentElement.selectSingleNode('//帖[@no="'+oVolume.no+'"]');
	if(xmlVolume==null) {
		xmlVolume = xmldoc.createElement("帖");
		xmlVolume.setAttribute("no",    oVolume.no);
		xmlVolume.setAttribute("name",  oVolume.name);
		xmlVolume.text = "\n";
		xmldoc.documentElement.appendChild(xmlVolume);
		xmldoc.documentElement.appendChild(xmldoc.createTextNode("\n"));
	}
	var xmlChapter = xmlVolume.selectSingleNode("章[@no="+Chapter.no+"]");
	if(xmlChapter==null) {
		xmlChapter = xmldoc.createElement("章");
		xmlChapter.setAttribute("no",   Chapter.no);
		xmlChapter.setAttribute("id",   Chapter.id);
		xmlChapter.setAttribute("name", Chapter.name);
		xmlChapter.text = "\n";
		xmlVolume.appendChild(xmlChapter);
		xmlVolume.appendChild(xmldoc.createTextNode("\n"));
	}
	var xmlParagraph = xmlChapter.selectSingleNode("段[@no="+Paragraph.no+"]");
	if(xmlParagraph==null) {
		xmlParagraph = xmldoc.createElement("段");
		xmlParagraph.setAttribute("no",   Paragraph.no);
		xmlParagraph.setAttribute("id",   Paragraph.id);
		xmlParagraph.setAttribute("name", Paragraph.name);
		xmlParagraph.text = "\n";
		xmlChapter.appendChild(xmlParagraph);
		xmlChapter.appendChild(xmldoc.createTextNode("\n"));
	}
	return xmlParagraph;
}

//*********************************************************************************
function newXmlNode(xmldoc, tagName)
{
	var elem = xmldoc.createElement(tagName);
	elem.text = "\n";
	appendChild2Paragraph(xmldoc, elem);
	return elem;
}

//*********************************************************************************
function appendChild2Paragraph(xmldoc, elem)
{
	var xmlParagraph = getXmlParagraph(xmldoc)
	xmlParagraph.appendChild(elem);
	xmlParagraph.appendChild(xmldoc.createTextNode("\n"));
}

//*********************************************************************************
function Volume(no)
{
	this.no = no;        // "01"
	this.name = "";      // "桐壺"
	this.title = "";     // "01 桐壺"
	this.title2 = "";    // "01 KIRITSUBO"
	this.subtitle = "";
	this.subtitle2 = "";
	this.notenocnt = 0;
	this.Chapters = new Array();
	this.Keywords = new Array();
	this.address = new Array();
	this.address["本文"] = "";
	this.address["渋谷栄一訳"] = "";
	this.address["与謝野晶子訳"] = "";
	this.address["ローマ字版"] = "";
	this.address["注釈"] = "";
	this.address["挿絵"] = "";
	this.cnt = new Array();
	this.xml = null;

}

//*********************************************************************************
function Keyword(type, kwno, keyword, pos)
{
	var id = type+kwno;
	this.type = type
	this.no = kwno;
	if(keyword) {
		if(pos) {
			this.pos = pos - Paragraph.pos[TextType];
			this.endpos = this.pos + keyword.length;
		}
		if(/[\n　<>]/.test(keyword)) {
			this.keyword = keyword.replace(/(?:\s|　|<(?:BR\/?|\/?P)>)+/g, "--").replace(/^--|<[^<>]*>|--$/g,"");
			this.endpos = null;
		}
		else {
			this.keyword = keyword;
		}
	}
	if(Paragraph) {
		this.Paragraph = Paragraph;
		if(pos) {
			this.lineid = Paragraph.currLineid;
			this.lineno = Paragraph.LineNo;
			this.pos = pos - Paragraph.pos[TextType];
		}
		if(Paragraph.keywords==null) Paragraph.keywords = new Array();
		if(Paragraph.keywordIDs==null) Paragraph.keywordIDs = new Array();
		this.ix = Paragraph.keywords.length;
		Paragraph.keywords[Paragraph.keywords.length] = this;
		Paragraph.keywordIDs[id] = this;
	}
	oVolume.Keywords[id] = this;
	if(oVolume.cnt[type]==null) oVolume.cnt[type] = 1;
	else oVolume.cnt[type] = oVolume.cnt[type] + 1;
	return this;
}

/*
function Description(kw, description)
{
	this.type = kw.type
	this.id = kw.type+kw.no;
	this.description = description;
	this.kws = new Array();
	this.kws[this.id] = kw;
	oVolume.Descriptions[this.id] = this;
}
*/

//*********************************************************************************
function NL_Proc(pos)
{
	var ret = "";
	switch(TextType) {
	case "本文":
	case "渋谷栄一訳":
	case "与謝野晶子訳":
	case "ローマ字版":
		if(Paragraph) {
			if(!flgIgnoreThisLine) {
				if(Paragraph.LineNo>=1) {
					if(Paragraph.lineEndPos==null) Paragraph.lineEndPos = new Array();
					if(Paragraph.lineEndPos[TextType]==null) Paragraph.lineEndPos[TextType] = new Array();
					Paragraph.lineEndPos[TextType][Paragraph.LineNo] = pos - Paragraph.pos[TextType];
				}
				Paragraph.LineNo = Paragraph.LineNo + 1; //段内LineNo。各段の先頭には改行があるので、LineNoは実質１始まりになる。
				Paragraph.currLineid = Paragraph.id+"."+Paragraph.LineNo;//行ＩＤを採番
				Paragraph.endpos[TextType] = pos + ret.length;
				ret = "<行 no=\""+Paragraph.LineNo+"\"/>";
				if(Paragraph.linePos==null) Paragraph.linePos = new Array();
				if(Paragraph.linePos[TextType]==null) Paragraph.linePos[TextType] = new Array();
				Paragraph.linePos[TextType][Paragraph.LineNo] = pos + ret.length - Paragraph.pos[TextType];
				if(isNaN(Paragraph.linePos[TextType][Paragraph.LineNo])) stop
			}
			if(Paragraph.srcLineNo==null) Paragraph.srcLineNo = new Array();
			if(Paragraph.srcLineNo[TextType]==null) Paragraph.srcLineNo[TextType] = new Array();
			Paragraph.srcLineNo[TextType][Paragraph.LineNo] = srcLineNo + 1;
		}
		flgIgnoreThisLine = false;
		break;
	default:
		break;
	}
	return ret;
}

//*********************************************************************************
function Quote4Serif_Proc(foundQuote4Serif, copiedPos)
{
	switch(foundQuote4Serif) {
	case '『':
	case '「':
		if(oVolume.cnt["詞#"]==null) oVolume.cnt["詞#"] = 0;
		oVolume.cnt["詞#"]++;
		if(Paragraph.currSerif==null) {
			Paragraph.currSerif = new Array();
			Paragraph.currSerifNest = 0;
		}
		else if(Paragraph.currSerifNest<0 ||
		        Paragraph.currSerifNest>=Paragraph.currSerif.length) stop;
		Paragraph.currSerifNest++;
		if(Paragraph.currSerif[Paragraph.currSerifNest]) stop; 
		var serifno = oVolume.cnt["詞#"];
		Paragraph.currSerif[Paragraph.currSerifNest] = new Keyword("詞", serifno, null, copiedPos+1);
		//new Keyword("引用符1", Paragraph.currSerif[Paragraph.currSerifNest].no, foundQuote4Serif, copiedPos);
		break;
	case '』':
	case '」':
		if(Paragraph.currSerif==null) stop
		if(Paragraph.currSerif[Paragraph.currSerifNest]==null) stop
		Paragraph.currSerif[Paragraph.currSerifNest].endpos = copiedPos - Paragraph.pos[TextType];
		//new Keyword("引用符2", Paragraph.currSerif[Paragraph.currSerifNest].no, foundQuote4Serif, copiedPos);
		Paragraph.currSerif[Paragraph.currSerifNest] = null;
		Paragraph.currSerifNest--;
		break;
	}
}

//*********************************************************************************
/// Chapter単位分割出力
function OutputEachDividedCchapter(xmldoc, coreFilename, bOutputWholeVolume/*帖全体出力要否*/)
{
	CreateParentFolder(coreFilename);
	xmldoc.documentElement.appendChild(xmldoc.createTextNode("\n"));
	//var Copyright = xmldoc.createElement('再編集版');
	//	Copyright.text = address1+"\n"+address2+"\n";
	//var Copyrights = xmldoc.createElement('著作権');
	//	Copyrights.appendChild(Copyright);
	var topname = xmldoc.documentElement.getAttribute("name");
	
	xmldoc.documentElement.appendChild(xmlCopyrights(topname));
	if(bOutputWholeVolume) {
		var wholeFilename = coreFilename.replace(/^(.+)([\\\/])/,"$1$2whole$2");
		CreateParentFolder(wholeFilename);
		xmldoc.save(wholeFilename+".xml"); // oVolume全体のファイルの出力
	}
	{	var xmlTemp = new ActiveXObject("Msxml2.DOMDocument.4.0");
		xmlTemp.async = false;
		xmlTemp.setProperty("SelectionLanguage", "XPath");
		xmlTemp.loadXML(xmlHeader+"<temp/>");
		var xmlTemp2 = new ActiveXObject("Msxml2.DOMDocument.4.0");
		xmlTemp2.async = false;
		xmlTemp2.setProperty("SelectionLanguage", "XPath");
		xmlTemp2.loadXML(xmlHeader+"<temp/>");
		var xmlTemp3 = new ActiveXObject("Msxml2.DOMDocument.4.0");
		xmlTemp3.async = false;
		xmlTemp3.setProperty("SelectionLanguage", "XPath");
		var nodeChapter;
		{	var Chapters = xmldoc.documentElement.selectNodes("//章");
			while(nodeChapter=Chapters.nextNode()) {
				xmlTemp.documentElement.appendChild(nodeChapter);
			}
		}
		{	var Chapters = xmlTemp.documentElement.selectNodes("//章");
			var nodeVolume = xmldoc.documentElement.selectSingleNode("//帖");
			while(nodeChapter=Chapters.nextNode()) {
				var ChapterNo = nodeChapter.getAttribute("no");
				nodeVolume.appendChild(nodeChapter);
				nodeVolume.appendChild(xmldoc.createTextNode("\n"))
				var filename = coreFilename+"."+ChapterNo+".xml";
				xmldoc.save(filename); // 章毎のファイルの出力
				xmlTemp2.documentElement.appendChild(nodeChapter);
				xmlTemp2.documentElement.appendChild(xmlTemp2.createTextNode("\n"))
				xmlTemp3.load(filename); // 章毎のファイルの出力
				xmlTemp3.save(filename); // 章毎のファイルの出力
			}
		}
		{	var Chapters = xmlTemp2.documentElement.selectNodes("//章");
			while(nodeChapter=Chapters.nextNode()) {
				nodeVolume.appendChild(nodeChapter);
				nodeVolume.appendChild(xmlTemp2.createTextNode("\n"))
			}
		}
	}
}

//*********************************************************************************
function parseGenjiVolume(infilename, prmTextType)
{
	Chapter = null;
	ChapterNo = 0;
	Paragraph = null;
	ParagraphNo = 0;
	var currPerson = null;
	var address = false;

	TextType = prmTextType;
	
	wholeFile = ReadWholeFile(infilename).replace(/\r/g, "").replace(/<br\/?>/gi, "<BR/>");
	if(TextType=="本文") {
		//出典・校訂からの戻りのリンク入口⇒削除(lineidによる行頭へのリンクに変更するため)
		wholeFile = wholeFile.replace(/<A name="?te?[0-9]+"?>((?:<BR\/?>|[^<>]+)*)<\/A>/ig, "$1");
	}
	lastEndPos = 0;
	copiedPos = 0;
	srcLineNo = 1;
	if(oVolume.wholeText==null) oVolume.wholeText = new Array();
	oVolume.wholeText[TextType] = wholeFile.replace(re_Main, re_Main_dispatch);
	postParser();
	switch(TextType) {
	case "本文":
	case "渋谷栄一訳":
	case "与謝野晶子訳":
		//帖.wholeText[TextType] = text.replace(/<行 [^<>]*>(\s*<\/段>)/g, "$1");
		{	//var textXmlFileName = infilename.replace(/^.*[\\/]([a-zA-Z]+)([0-9]+)\.html/i,xmldir+"Genji$2/$1$2");
			//if(textXmlFileName==infilename) stop
			var textXmlCoreFileName = OutputXmlFileNames[TextType] + oVolume.no;
			CreateParentFolder(textXmlCoreFileName);
			OutputEachDividedCchapter(xmlDoc[TextType], textXmlCoreFileName, TextType=="本文"); // 本文の帖全体出力要否は、DiffHiragana.wsfで使用するため。
		}
		//WriteWholeFile(textXmlFileName, xmlHeader+oVolume.wholeText[TextType]);
		break;
	case "ローマ字版":
		{	
			var textXmlCoreFileName = OutputXmlFileNames[TextType] + oVolume.no;
			CreateParentFolder(textXmlCoreFileName);
			OutputEachDividedCchapter(xmlDoc[TextType], textXmlCoreFileName);

		  //var eiriXmlCoreFileName = infilename.replace(/^.*[\\/]([a-zA-Z]+)([0-9]+)\.html/i,xmldir+"Genji$2/eiri$2");
			var eiriXmlCoreFileName = OutputXmlFileNames["絵入源氏物語の挿絵"] + oVolume.no;
			CreateParentFolder(eiriXmlCoreFileName);
			
			//alert('oVolume.address["挿絵"] = ' + oVolume.address["挿絵"]);

			var xmlVolume = xmlDoc["絵入源氏物語の挿絵"].documentElement.selectSingleNode('//帖[@no="'+oVolume.no+'"]');
			var elem = newXmlDoc("<著作権>"+oVolume.address["挿絵"]+"</著作権>");
			xmlVolume.appendChild(elem.documentElement);
			xmlVolume.appendChild(elem.createTextNode("\n"));
			OutputEachDividedCchapter(xmlDoc["絵入源氏物語の挿絵"], eiriXmlCoreFileName);
		}
		break;
	default:
		break;
	}
}

//*********************************************************************************
function MainParserXml(no)
{
	oVolume = null;
	oVolume = new Volume(no);
	xmlInit();

	parseGenjiVolume(indir+"version" +no+".html", "渋谷栄一訳");
	parseGenjiVolume(indir+"note"    +no+".html", "注釈");
	parseGenjiVolume(indir+"text"    +no+".html", "本文");
	parseGenjiVolume(indir+"roman"   +no+".html", "ローマ字版");

	var yosanoFilename = yosanodir + "yosano" +no+".html";
	if(fso.FileExists(yosanoFilename)) {
		parseGenjiVolume(yosanoFilename,  "与謝野晶子訳");
		var yosanoRubyXmlCoreFileName = OutputXmlFileNames["与謝野晶子訳のルビ"] + oVolume.no;
		CreateParentFolder(yosanoRubyXmlCoreFileName);
		OutputEachDividedCchapter(xmlDoc["与謝野晶子訳のルビ"], yosanoRubyXmlCoreFileName);
	}
	else if(no*1<=5||no*1==47) stop
}
