﻿var tblHiragana = new Array();
var Vowels = "a i u e o ya yu yo".split(" "); // 母音

mkTblHiragana('' ,"あ い う え お や ゆ よ");
mkTblHiragana('x',"ぁ ぃ ぅ ぇ ぉ ゃ ゅ ょ");
mkTblHiragana('k',"か き く け こ きゃ きゅ きょ");
mkTblHiragana('s',"さ し す せ そ しゃ しゅ しょ");
mkTblHiragana('t',"た ち つ て と ちゃ ちゅ ちょ");
mkTblHiragana('n',"な に ぬ ね の にゅ にゅ にょ");
mkTblHiragana('h',"は ひ ふ へ ほ ひゃ ひゅ ひょ");
mkTblHiragana('m',"ま み む め も みゃ みゅ みょ");
mkTblHiragana('r',"ら り る れ ろ りゃ りゅ りょ");
mkTblHiragana('w',"わ ゐ - ゑ を - - -");
mkTblHiragana('g',"が ぎ ぐ げ ご ぎゃ ぎゅ ぎょ");
mkTblHiragana('z',"ざ じ ず ぜ ぞ じゃ じゅ じょ");
mkTblHiragana('d',"だ ぢ づ で ど ぢゃ ぢゅ ぢょ");
mkTblHiragana('b',"ば び ぶ べ ぼ びゃ びゅ びょ");
mkTblHiragana('p',"ぱ ぴ ぷ ぺ ぽ ぴゃ ぴゅ ぴょ");
mkTblHiragana('j',"じゃ じ じゅ じぇ じょ じゃ じゅ じょ");
mkTblHiragana('f',"ふぁ ふぃ ふ ふぇ ふぉ ふゃ ふゅ ふょ");
mkTblHiragana('q',"くぁ くぃ く くぇ くぉ くゃ くゅ くょ");
mkTblHiragana('sh',"しゃ し しゅ しぇ しょ - - -");
mkTblHiragana('ch',"ちゃ ち ちゅ ちぇ ちょ - - -");
mkTblHiragana('th',"てゃ てぃ てゅ てぇ てょ - - -");
mkTblHiragana('ts',"つぁ つぃ つ つぇ つぉ - - -");
mkTblHiragana('dh',"でゃ でぃ でゅ でぇ でょ - - -");
mkTblHiragana('wh',"うぁ うぃ う うぇ うぉ - - -");
mkTblHiragana('kw',"か - - け - - - -");
mkTblHiragana('gw',"が - - げ - - - -");
tblHiragana["n"]  = "ん"; //未使用
tblHiragana["n'"] = "ん"; //未使用
tblHiragana["m"]  = "む"; //未使用
tblHiragana["m'"] = "む"; //未使用
tblHiragana["a'"] = "あ";
tblHiragana["k"] = "っ";
tblHiragana["s"] = "っ";
tblHiragana["t"] = "っ";
tblHiragana["p"] = "っ";
tblHiragana["c"] = "っ";
tblHiragana["b"] = "っ";
tblHiragana["d"] = "っ";
tblHiragana["xtu"] = "っ";
tblHiragana["yi"] = "い";
tblHiragana["ye"] = "え";


function mkTblHiragana(consonant/*子音*/, strHiragana)
{
	var Hiraganas = strHiragana.split(" ");
	for(i in Hiraganas) {
		if(Hiraganas[i]!="-") {
			tblHiragana[consonant+Vowels[i]] = Hiraganas[i];
		}
	}
}
var reRomaji2Hiragana = /((?:[kstnhmrgzdbpjfqx]?(?:y(?=[auo]))?|w|[scdw]h)[aiueo]|ye|yi|[kg]w[ae])|([nm](?:[''](?=y?[aiueo]))?)|(k(?=k)|s(?=s)|t(?=[-t])|p(?=p)|c(?=c)|b(?=b)|d(?=d))|([,.""''!?])|([ 　\t-]+|<副題>[^<>]*<\/副題>)|<著作権>(.*)<\/著作権>|(<\?xml .*?\?>)|(<[^<>]*>|&lt;[^<>]*&gt;)/gi;

var Chapter = null;
var ChapterNo = -1;
var Paragraph = null;
var ParagraphNo = -1;
var currLineNo = -1;

var fncRomaji2Hiragana_quote = 0;

//function fncRomaji2Hiragana($0,moji,apostrophe1,nn,apostrophe2,xtu,delim,ignore,tag,pos)
function fncRomaji2Hiragana($0,moji,nn,xtu,delim,ignore,Copyrights,xmlhdr,tag,pos)
{
	var ret = "";
	if(moji) {
		ret=tblHiragana[moji.toLowerCase()];
		if(ret==null) stop;　
	}
	else if(nn) {
		ret = "ん";
		//ret=(nn= "m" ? "む": "ん");
		//ret=tblHiragana[nn.toLowerCase()];
	}
	else if(xtu) {
		ret="っ"
	}
	else if(delim) {
		switch(delim) {
		case ',':
			ret="、"
			break;
		case '.':
		case "!":
		case "?":
			ret="。"
			break;
		case '"':
		case "'":
			ret=delim;
			break;
		}
	}
	else if(ignore) {
		ret=""
	}
	else if(tag) {
		tag = tag.replace(/&lt;/g, "<")
		         .replace(/&gt;/g, ">")
		if(result=/<([帖章段行]) +no="([0-9]+)"/.exec(tag),result) {
      ret = tag;
			/*
			var tagname = result[1];
			var no = result[2];
			ret = '<'+tagname+' no="'+no+'"';
			switch(tagname) {
			case "帖":
				ret = ret + ' name="'+oVolume.name+'">';
				break;
			case "章":
				ChapterNo = no;
				Chapter = oVolume.Chapters[no];
				if(Chapter==null) stop;
				ret = ret + ' name="'+Chapter.name+'" romanLineNo="'+Chapter.srcLineNo+'">';
				break;
			case "段":
				ParagraphNo = no;
				Paragraph = Chapter.Paragraphs[no];
				if(Paragraph==null) stop;
				ret = ret + ' name="'+Paragraph.name+'" romanLineNo="'+Paragraph.srcLineNo+'">';
				break;
			case "行":
				currLineNo = no;
				ret = ret + ' romanLineNo="'+Paragraph.srcLineNo["ローマ字版"][currLineNo] + '">';
				break;
			default:
				ret = ret + ">";
			}*/
		}
		else {
			switch(tag) {
			case '<テキスト name="ローマ字版">':
				ret = '<テキスト name="ひらがな版" srcLineNo="ローマ字版">';
				break;
			case "<和歌/>":
				break;
			case "</段>":
				if(fncRomaji2Hiragana_quote) {
					myReportWriter.write("第"+Paragraph.id.replace(".","章 第")+"段で引用符が閉じられていない。<BR>\n");
					ret = ret + '<error msg="引用符が閉じられていない。" />\n';
					fncRomaji2Hiragana_quote = 0;
				}
			default:
				ret = ret + tag;
			}
		}
	}
	else if(Copyrights) {
		if(Copyrights.indexOf("再編集プログラム") < 0) {
			ret = "<著作権>"+Copyrights+"<BR/>ひらがな版変換 Powered By 再編集プログラム</著作権>\n";
		}
	}
	else if(xmlhdr) {
		ret = "";
	}
	else stop;
	return ret;
}

function MakeHiraganaXml()
{
	var no = oVolume.no;
	
	//var hiraganaXmlFileName = xmldir+"Genji"+no+"/hiragana"+no+".xml";
	//CreateParentFolder(hiraganaXmlFileName);
	//fpHiraganaXml = new MyStreamWriter(hiraganaXmlFileName);
	//fpHiraganaXml.write(xmlHeader);
	xmlDoc["ローマ字版"].documentElement.removeChild(xmlDoc["ローマ字版"].documentElement.selectSingleNode('著作権'));
	oVolume.wholeText["ひらがな版"] = xmlDoc["ローマ字版"].xml.replace(reRomaji2Hiragana, fncRomaji2Hiragana);
	var xmldoc = xmlDoc["ひらがな版"]
	xmldoc.loadXML(oVolume.wholeText["ひらがな版"]);
	//fpHiraganaXml.write(oVolume.wholeText["ひらがな版"]);
	//var hiraganaXmlCoreFileName = xmldir+"Genji"+no+"/hiragana"+no;
	var hiraganaXmlCoreFileName = OutputXmlFileNames["ひらがな版"] + oVolume.no;
	CreateParentFolder(hiraganaXmlCoreFileName);
	OutputEachDividedCchapter(xmldoc, hiraganaXmlCoreFileName, true); // oVolume全体出力要は、DiffHiragana.wsfで使用するため。
	//fpHiraganaXml.close();
	//fpHiraganaXml = null;
}
