﻿var reDelSpace        =  /[ ]/g;
var reDelDelims       =  /[、。，．「」『』　 ]/g;
var reDelTagsOrDelims = /((?:[、。，．「」『』　]|\s)+)|(<[^<>]*>)/g

var reCvChar = /&lt;|&gt;|&amp;/g;
var cvChar = new Array();
	cvChar["&lt;"] = "＜";
	cvChar["&gt;"] = "＞";
	cvChar["&amp;"] = "＆";
function fncCvChar(char)
{
	return cvChar[char];
}

function MakeNotesXml()
{
	var no = oVolume.no;
	
	Chapter = null;
	ChapterNo = -1;
	Paragraph = null;
	ParagraphNo = -1;
	
	TextType = "本文"

	//var notesXmlFileName = xmldir+"Genji"+no+"/notes"+no+".xml";
	//CreateParentFolder(notesXmlFileName);
	//var fpNotesXml = new MyStreamWriter(notesXmlFileName);
	//fpNotesXml.write(xmlHeader+'<コメント for="'+TextType+'">\n');
	//fpNotesXml.write('<oVolume no="'+(oVolume.no)+'" name="'+oVolume.name+'">\n');
	for(ChapterNo=1; ChapterNo<oVolume.Chapters.length; ++ChapterNo)
	{
		Chapter = oVolume.Chapters[ChapterNo];
		if(Chapter==null) continue;
		//fpNotesXml.write('<章 no="'+ChapterNo+'" name="'+Chapter.name+'">\n');
		for(ParagraphNo=1; ParagraphNo < Chapter.Paragraphs.length; ++ParagraphNo)
		{
			
			Paragraph = Chapter.Paragraphs[ParagraphNo];
			if(Paragraph==null) continue;
			var xmlParagraphs = new Array();
			if(Paragraph.text==null) Paragraph.text = new Array();
			if(Paragraph.text[TextType]==null) {
				Paragraph.text[TextType] = oVolume.wholeText[TextType].substring(Paragraph.pos[TextType],Paragraph.endpos[TextType]);
			}
			//trace(traceid+"-2テキスト位置変換表作成");
			// 句読点、引用符、タグなどを取り除いたテキストを作成するとともに、そのテキストの位置から元のテキストの位置への変換表を作る。
			Paragraph.cvPos = new Array();
			Paragraph.cvPosInv = new Array();
			Paragraph.cvLineNo = new Array();
			var lastPos = 0;
			var lastNoTagsOrDelemsPos = 0;
			Paragraph.LineNo = 0;
			Paragraph.noTagsOrDelems = Paragraph.text[TextType].replace(reDelTagsOrDelims,
				function($0, delim, tag, pos)
				{
					var noTagsOrDelemsPos = lastNoTagsOrDelemsPos + (pos - lastPos);
					var i;
					for(i=lastNoTagsOrDelemsPos; i<noTagsOrDelemsPos; ++i) {
						Paragraph.cvPos[i] = lastPos + (i-lastNoTagsOrDelemsPos);
						Paragraph.cvPosInv[Paragraph.cvPos[i]] = i;
						Paragraph.cvLineNo[Paragraph.cvPos[i]] = Paragraph.LineNo;
					}
					if(tag) {
						if(result=/<行 no="([0-9]+)"/.exec(tag), result) {
							Paragraph.LineNo = result[1]*1;
						}
					}
					lastPos = pos + $0.length;
					lastNoTagsOrDelemsPos = noTagsOrDelemsPos;
					return "";
				}
			);
			if(Paragraph.noTagsOrDelems=="") stop;

			//trace(traceid+"-3注釈の出現位置を求める");
			//注釈の出現位置を求める。
			var searchFromPos = new Array();
				searchFromPos["注釈"] = 0;
				searchFromPos["出典"] = 0;
				searchFromPos["校訂"] = 0;
			var i;
			var svCommentNo = 0;
			var prevCommentIx = null;
			for(i in Paragraph.keywords) {
				var kw = Paragraph.keywords[i];
				//if(kw.id.indexOf("-")>=0) continue; //子キーワードをスキップ
				//var keywords;
				//var kwSearchFromPoss;
				//var note;
				switch(kw.type) {
				//case "引用符1":
				//case "引用符2":
				//	continue; //子キーワードをスキップ
				case "出典":
				case "校訂":
					//if(kw.type+kw.no=="校訂9") stop
					if(kw.keyword.indexOf("--")<0 && kw.pos && kw.endpos) {
						continue;
					}
					if(kw.pos==null) stop
					else if(kw.endpos==null) {
				        var LineNo = Paragraph.cvLineNo[kw.pos];                     // 行番号
				        var ColumnNo = kw.pos - Paragraph.linePos[TextType][LineNo]; // 桁番号
						myReportWriter.writeln("<LI style='color:grey'>第"+ChapterNo+"章 第"+ParagraphNo+"段 "+kw.type+kw.no + "【" + kw.keyword + "】endpos不明：注釈に準じた方法でendposを探す。第"+LineNo+"行"+ColumnNo+"桁 pos="+kw.pos+"《" +Paragraph.text[TextType].substr(kw.pos, 30) + "…》</LI>");
					}
					else stop
					
				case "注釈":
					//if(kw.type+kw.no == "注釈825") stop
					///// この部分は、複数行にまたがったキーワードにマッチする正規表現を作って探すように変更する。
					var kwSearchFromPos;
					var prev = null;
					if(kw.type=="注釈") {
						kwSearchFromPos = searchFromPos[kw.type];
						if(prevCommentIx) {
							prev = Paragraph.keywords[prevCommentIx];
						}
						prevCommentIx = i;
					}
					else {
						kwSearchFromPos = Paragraph.cvPosInv[kw.pos];
					}
					kw.keywordNoDelims = kw.keyword.replace(reDelDelims, "");
					var strRe = "(" + kw.keywordNoDelims.replace(/--/g, ")(.*?)(") + ")";
					var re = new RegExp(strRe,"g");
					//kw.posNoDelims = Paragraph.noTagsOrDelems.indexOf(kw.keywordNoDelims,kwSearchFromPos);
					kw.posNoDelims = -1;
					//for(var toppos=kwSearchFromPos; toppos>=0 && kw.posNoDelims<kwSearchFromPos; toppos-=kwSearchFromPos)
					{
						//while(result=re.exec(toppos==0? Paragraph.noTagsOrDelems: Paragraph.noTagsOrDelems.substr(toppos)), result)
						while(result=re.exec(Paragraph.noTagsOrDelems.substr(kwSearchFromPos)))
						{
							if(kw.posNoDelims>=kwSearchFromPos) {
								// 同じキーワードが２度出現した。
								var LineNo = Paragraph.cvLineNo[kw.pos];                     // 行番号
								var ColumnNo = kw.pos - Paragraph.linePos[TextType][LineNo]; // 桁番号
								var foundpos = Paragraph.cvPos[kwSearchFromPos+result.index];
								var foundLineNo = Paragraph.cvLineNo[foundpos];
								var foundColumnNo = foundpos - Paragraph.linePos[TextType][foundLineNo];
								if(kw.type!="注釈" || !prev || kw.pos > prev.pos) {
									var msg = "<LI"+(kw.type=="注釈" ? " style='color:grey'" : "")+">第"+ChapterNo+"章 第"+ParagraphNo+"段 "+kw.type+kw.no + "【" + kw.keyword + "】あいまい。すでに第"+LineNo+"行"+ColumnNo+"桁にあるので、第"+foundLineNo+"行"+foundColumnNo+"桁のものは無視します。";
									if(prev) {
										var prevLineNo = Paragraph.cvLineNo[prev.pos];
										var prevColumnNo = prev.pos - Paragraph.linePos[TextType][prevLineNo];
										msg += "prev="+prev.type+prev.no+"(第"+prevLineNo+"行"+prevColumnNo+"桁)";
										//for(var ix in prev) {
										//	msg += "; prev["+ix+"]="+prev[ix];
										//}
									}
									//msg += "<BR>\n kwSearchFromPos="+kwSearchFromPos;
									//msg += "; Paragraph.cvPos[result.index]="+Paragraph.cvPos[result.index]
									//for(var ix in kw) {
									//	msg += "; kw["+ix+"]="+kw[ix];
									//}
									//var prevkw = 
									//+ "; kw.posNoDelims="+kw.posNoDelims
									//+ "; kw.pos="+kw.pos
									msg += "</LI>";
									myReportWriter.writeln(msg);
									continue;
								}
								else {
									var msg = "<LI style='color:grey'>第"+ChapterNo+"章 第"+ParagraphNo+"段 "+kw.type+kw.no + "【" + kw.keyword + "】あいまい。すでに第"+LineNo+"行"+ColumnNo+"桁にありますが、第"+foundLineNo+"行"+foundColumnNo+"桁のもので上書きします。";
									if(prev) {
								        var prevLineNo = Paragraph.cvLineNo[prev.pos];
								        var prevColumnNo = prev.pos - Paragraph.linePos[TextType][prevLineNo];
										msg += "prev="+prev.type+prev.no+"(第"+prevLineNo+"行"+prevColumnNo+"桁)";
										//for(var ix in prev) {
										//	msg += "; prev["+ix+"]="+prev[ix];
										//}
									}
									msg += "</LI>";
									myReportWriter.writeln(msg);
								}
						    }
						    var posNoDelims    = result.index     + kwSearchFromPos;
							if(kw.type!="注釈") {
							   if(kw.pos > Paragraph.cvPos[posNoDelims]) continue;
							   if(kw.pos != Paragraph.cvPos[posNoDelims]) stop;
							}
						    kw.posNoDelims    = posNoDelims;
						    kw.endposNoDelims = result.lastIndex + kwSearchFromPos;
							kw.nextposNoDelims = result.index + result[1].length;
							kw.pos = Paragraph.cvPos[kw.posNoDelims];
							kw.endpos = Paragraph.cvPos[kw.endposNoDelims-1]+1;
							kw.keywordOriginal = kw.keyword;
							kw.keyword = Paragraph.text[TextType].substring(kw.pos, kw.endpos).replace(/(?:\s|　|<[^<>]*>)+/g, "--");
							if(kw.type=="注釈" && (kw.keywordNoDelims.indexOf("--")>0 || kw.keyword.indexOf("--")>0) ) {
								if(kw.keywordOriginal != kw.keyword &&
								   kw.keywordNoDelims.replace(/--/g, "") != kw.keyword.replace(reDelDelims, "").replace(/--/g, "") )
								{
									var newkw = Paragraph.text[TextType].substring(kw.pos, Paragraph.cvPos[kw.posNoDelims+result[1].length-1]+1) + "--"
									          + Paragraph.text[TextType].substring(        Paragraph.cvPos[kw.endposNoDelims-result[3].length], kw.endpos);
									if(newkw!=kw.keywordOriginal) {
										var LineNo = Paragraph.cvLineNo[kw.pos];
										var ColumnNo = kw.pos - Paragraph.linePos[TextType][LineNo];
										myReportWriter.writeln("<LI>第"+ChapterNo+"章 第"+ParagraphNo+"段 第"+LineNo+"行"+ColumnNo+"桁 "+kw.type+kw.no + "【" + kw.keywordOriginal + "】⇒【" + kw.keyword + "】⇒【" + newkw + "】"+kw.description+"</LI>");
									}
									kw.keyword = newkw;
								}
							}
						}
					}
					if(kw.pos==null || kw.endpos==null) {
						//キーワードが見つからない。
						myReportWriter.writeln("<LI><FONT color='red'>第"+ChapterNo+"章 第"+ParagraphNo+"段 "+kw.type+kw.no + "【" + kw.keyword + "】不一致</FONT></LI>");
						continue;
					}
					else if(kw.posNoDelims<kwSearchFromPos) {
						//キーワードの順序が前後している。
						myReportWriter.writeln("<LI><FONT color='red'>第"+ChapterNo+"章 第"+ParagraphNo+"段 "+kw.type+kw.no + "【" + kw.keyword + "】逆順。"+
							"pos=" +kw.posNoDelims +"(第"+Paragraph.cvLineNo[Paragraph.cvPos[kw.posNoDelims ]]+"行)に見つかりましたが、"+
							"pos>="+kwSearchFromPos+"(第"+Paragraph.cvLineNo[Paragraph.cvPos[kwSearchFromPos]]+"行)を期待していました。</FONT></LI>");
						continue;
					}
					searchFromPos[kw.type] = kw.nextposNoDelims;
					break;
				case "和歌":
					{	kw.pos = Paragraph.linePos[TextType][kw.lineno];
						kw.endpos = Paragraph.linePos[TextType][kw.lineno+2];
						kw.keyword = Paragraph.text[TextType].substring(kw.pos, kw.endpos)
						if(result=/^(([「『  ]*)([^<>「」『』\n]*?)((?:\s|　|<[^<>]*>)+)([^<>「」『』\n]*?))([」』 ]*(?:\s*<[^<>]*>)*\s*)$/.exec(kw.keyword), result)
						{
							kw.endpos = kw.pos + result[1].length;
							kw.pos = kw.pos + result[2].length;
							kw.keyword = Paragraph.text[TextType].substring(kw.pos, kw.endpos).replace(/\s|　|<[^<>]*>/g, "--");
						}
						else stop
					}
					break;
				case "詞":
					if(kw.keyword==null) {
						if(kw.pos==null||kw.endpos==null) { alert("case \"詞\": kw.pos=="+kw.pos+" || kw.endpos=="+kw.endpos); stop;}
						kw.keyword = Paragraph.text[TextType].substring(kw.pos, kw.endpos).replace(/(?:\s|　|<[^<>]*>)+/g, "--");
						
					}
					break;
				}
			}
			Paragraph.keywords.sort( // 参照順に並べ替える。
				function(L,R) {
					if(L==null) return 1;
					if(R==null) return -1;
					// 一次キー：pos 昇順
					if(L.pos==null) return 1;
					if(R.pos==null) return -1;
					if(isNaN(L.pos)) return 1;
					if(isNaN(R.pos)) return -1;
					if(L.pos!=R.pos) return L.pos-R.pos;
					// 二次キー：endpos 昇順
					if(L.endpos==null) return 1;
					if(R.endpos==null) return -1;
					if(isNaN(L.endpos)) return 1;
					if(isNaN(R.endpos)) return -1;
					if(L.endpos!=R.endpos) return L.endpos-R.endpos;
					// 三次キー：type 順序はtypeSeqで定義
					var typeSeq = "詞 和歌 注釈 出典 校訂";
					var Lseq = typeSeq.indexOf(L.type);
					var Rseq = typeSeq.indexOf(R.type);
					if(Lseq<0) return 1;
					if(Rseq<0) return -1;
					if(Lseq!=Rseq) return Lseq-Rseq;
					return 0;
				}
			);
			var k;
			for(k=0; k < Paragraph.keywords.length; ++k) {
				var kw = Paragraph.keywords[k];
				if(kw==null) continue;
				//if(kw.type+kw.no=="校訂78") stop
				//if(kw.pos==null || kw.endpos==null) continue;
				var tagname = kw.type;
				var xmldoc = xmlDoc[tagname];
				//var opentag = false;
				//switch(kw.type) {
				//case "詞":
				//	break;
				//case "引用符2":
				//	fpNotesXml.write('</詞>\n');
				//	break;
				//case "引用符1":
				//	kw = Paragraph.keywordIDs["詞"+kw.no];
				//	tagname = kw.type;
				//	opentag = true;
				//default:
					if(kw.pos) {
						var lineno = Paragraph.cvLineNo[kw.pos];
						if(lineno==null) lineno = Paragraph.cvLineNo[kw.pos+1];
						if(lineno) {
							kw.pos2 = lineno+":"+(kw.pos-Paragraph.linePos[TextType][lineno]);
						}
						else stop;
						if(kw.endpos) {
							var endlineno = null;
							var i;
							for(i=1;endlineno==null;i++) {
								endlineno = Paragraph.cvLineNo[kw.endpos-i];
								if(kw.endpos-i<=kw.pos) break;
							}
							if(endlineno) {
								kw.endpos2 = (endlineno==lineno? "": endlineno+":")
								           + (kw.endpos-Paragraph.linePos[TextType][lineno]);
							}
							else stop;
						}
						else stop
					}
					{	//var str = '<'+tagname+' no="'+kw.no
						//	+ (kw.keyword==null ? '': '" kw="'+kw.keyword)
						//	+ '">'
						//	+ (kw.pDescription    &&
						//	   kw.pDescription.id==(kw.type+kw.no) ? kw.pDescription.description.replace(reCvChar, fncCvChar) : "")
						//	+ '\n';
						if(xmlParagraphs[tagname]==null) {
							xmlParagraphs[tagname] = getXmlParagraph(xmldoc)
						}
						var xmlParagraph = xmlParagraphs[tagname];
						var xmlKW;
						if(kw.description) {
							var xml = new ActiveXObject("Msxml2.DOMDocument.4.0");
							xml.async = false;
							xml.setProperty("SelectionLanguage", "XPath");
							xml.loadXML(xmlHeader+"<"+tagname+">"+kw.description.replace(/<BR\/?>/gi,"<BR/>")+"</"+tagname+">");
							xmlKW = xml.documentElement
							xmlParagraph.appendChild(xmlKW);
							xmlParagraph.appendChild(xmldoc.createTextNode("\n"));
							//xmlKW.setAttribute("description", kw.description);
						}
						else {
							xmlKW = xmldoc.createElement(tagname);
							xmlParagraph.appendChild(xmlKW);
						}
						xmlKW.setAttribute("no",      kw.no);
						xmlKW.setAttribute("行",      lineno);
						xmlKW.setAttribute("keyword", kw.keyword);
						xmlKW.setAttribute("descLineNo", kw.srcLineNo);
						//xmlKW.text = "\n";
						if(kw.pos && !isNaN(kw.pos)) {
							if(kw.endpos==null) stop;
							// posとendposが正しく設定されていることを検証する。
							var subkws  = kw.keyword.split("--");
							//if(subkws.length!=1) stop
							var text    = Paragraph.text[TextType];
							var linePos = Paragraph.linePos[TextType];
							// var lineno  = Paragraph.cvLineNo[kw.pos]; -- 設定済み。しかも、この値とは異なる場合あり。
							var pos = kw.pos - linePos[lineno];
							if(subkws.length >= 2 && kw.type == "注釈") {
								myReportWriter.writeln("<LI><FONT color='red'>第"+ChapterNo+"章 第"+ParagraphNo+"段 "+lineno+"行 "+kw.type+kw.no + "【" + kw.keyword + "】subkws.length="+subkws.length+"</FONT></LI>");
							}
							var i;
							for(i=0; i<subkws.length; ++i) {
								if(text.substr(pos+linePos[lineno],subkws[i].length).replace(/(?:\s|　|<[^<>]*>)+/g, "")!=subkws[i]) stop;
								if(false) {
									var elem = xmldoc.createElement("開始");
									elem.setAttribute("行", lineno);
									elem.setAttribute("桁", pos);
									elem.setAttribute("srcLineNo", Paragraph.srcLineNo[TextType][lineno]);
									xmlKW.appendChild(elem);
									elem = xmldoc.createElement("終了");
									elem.setAttribute("行", lineno);
									elem.setAttribute("桁", pos+subkws[i].length);
									xmlKW.appendChild(elem);
								}
								else {
									var elem = xmldoc.createElement("参照");
									elem.setAttribute("行", lineno);
									elem.setAttribute("開始桁", pos);
									elem.setAttribute("終了桁", pos+subkws[i].length);
									elem.setAttribute("keyword", subkws[i]);
									elem.setAttribute("srcLineNo", Paragraph.srcLineNo[TextType][lineno]);
									xmlKW.appendChild(elem);
								}
								//xmlKW.appendChild(xmldoc.createTextNode("\n"));
								/*if(subkws.length!=1) {
									if(subkws.length==2) {
										lineno = Paragraph.cvLineNo[kw.endpos-1];
										pos = kw.endpos - linePos[lineno] - subkws[1].length;
									}
									else*/
									if((i+1)<subkws.length) {
										nextoffs = text.substring(linePos[lineno]+pos+subkws[i].length,linePos[lineno+1]).indexOf(subkws[i+1]);
										if(nextoffs>=0) {
											pos += subkws[i].length + nextoffs;
										}
										else {
											pos = text.substring(linePos[lineno+1],linePos[lineno+2]).indexOf(subkws[i+1]);
											if(pos<0) stop
											lineno ++;
										}
									}
								//}
							}
						}
						else if(kw.endpos) stop;
						//if(!opentag) str = str + '</'+tagname+'>\n';
						//fpNotesXml.write(str);
					}
				//}
			}
			//fpNotesXml.write('</段>\n');
			//trace(traceid+"-4当該段の処理終了");
		}
		//fpNotesXml.write('</章>\n');
	}
	//fpNotesXml.write('</oVolume>\n');
	//fpNotesXml.write("</コメント>\n");
	//fpNotesXml.close();
	//fpNotesXml = null;
	//var notesXmlCoreFileName = xmldir+"Genji"+no+"/notes"+no;
	OutputEachDividedCchapter(xmlDoc.注釈, OutputXmlFileNames["渋谷栄一による注釈"] + oVolume.no);
	OutputEachDividedCchapter(xmlDoc.出典, OutputXmlFileNames["渋谷栄一による出典"] + oVolume.no);
	OutputEachDividedCchapter(xmlDoc.校訂, OutputXmlFileNames["渋谷栄一による校訂"] + oVolume.no);
	OutputEachDividedCchapter(xmlDoc.和歌, OutputXmlFileNames["和歌一覧"] + oVolume.no);
	OutputEachDividedCchapter(xmlDoc.詞,   OutputXmlFileNames["詞一覧"] + oVolume.no);
}
