﻿var startTime = new Date().getTime() //処理開始時刻
var procTimes = new Array(); //処理開始時刻からの経過時間を添字とする配列。単位はミリ秒だが分解能はティック(1/64秒)単位。各要素は同一ティック内に発生したトレースのIDを到着順に保持する配列となる。

// Constants for ActiveXObject("adodb.Stream")
var adModeRead           = 1; //読み取り専用の権限
var adModeWrite          = 2; //書き込み専用の権限
var adModeShareDenyWrite = 8; //書き込み権限によるほかのユーザーからの接続を禁止します。
var adTypeBinary = 1;  // 保存データの種類:バイナリ
var adTypeText   = 2;  // 保存データの種類:テキスト
var adReadAll    = -1; // 読み込み方法:全行
var adReadLine   = -2; // 読み込み方法:一行ごと
var adWriteChar  = 0;  // 書き込み方法:改行なし
var adWriteLine  = 1;  // 書き込み方法:改行あり
var adSaveCreateNotExist  = 1; // ファイル保存方法:ない場合は新規作成
var adSaveCreateOverWrite = 2; // ファイル保存方法:ある場合は上書き

function trace(id)
{
	var currTime = new Date().getTime() - startTime;
	if(procTimes[currTime] == null) procTimes[currTime] = new Array();
	procTimes[currTime][procTimes[currTime].length] = id;
}

/// ファイル全体を読み込んで文字列で返す。
/// テキストファイルを読み込んだ場合、改行文字の種類(CRLFかLFのみ)をchNLに設定する。
function CreateParentFolder(FullName)
{
	var result = null
	if(result=/^(.*)[\\\/]([^\\\/]*)$/.exec(FullName),result) {
		var PathName = result[1]+"";
		if(!fso.FolderExists(PathName)) {
			CreateParentFolder(PathName);
			MyLog("\tCreateFolder\t"+PathName);
			fso.CreateFolder(PathName);
		}
	}
}

function MyStream(
    type,       ///< adTypeText (default) or adTypeBinary
    strLang)    ///< adodb.Streamで入出力する言語："Shift_JIS"、"UTF-8"、"EUC-jp"、"ASCII"、etc (注意：ASCIIを包含するもののみ使用可。"UNICODE"は使用不可)
{
    var fp = new ActiveXObject("ADODB.Stream");
    fp.Type = (type ? type : adTypeText);
    fp.Charset = (strLang ? strLang : "UTF-8");
    fp.Open();

    fp.Position = 0;

    this.Stream = function MyStream_Stream() {
        return fp;
    }

    this.NL = "\r\n";

    this.Position = function MyStream_Position() {
        return fp.Position;
    }

    this.setPosition = function MyStream_setPosition(value) {
        fp.Position = value;
    }

    this.Size = function MyStream_Size() {
        return fp.Size;
    }

    this.Close = function MyStream_Close() {
        fp.Close();
    }
}

function MyStreamReader(filename,
    type,       ///< adTypeText (default) or adTypeBinary
    strLang)    ///< adodb.Streamで入出力する言語："Shift_JIS"、"UTF-8"、"EUC-jp"、"ASCII"、etc (注意：ASCIIを包含するもののみ使用可。"UNICODE"は使用不可)
{
    MyStream.call(this, type, strLang);
    var fp = this.Stream();

	try {
    	fp.LoadFromFile(filename);
    }
    catch(ex) {
		alert(ex.description + "\n MyStreamReader(" + filename + ", " + type + ", " + strLang + ");");
		throw ex;
	}

    this.ReadAll = function MyFileReader_ReadAll() {
        return fp.ReadText(adReadAll);
    }

    this.ReadLine = function MyFileReader_ReadLine() {
        return fp.ReadText(adReadLine);
    }

    this.Read = function MyFileReader_Read(chars) {
        return fp.ReadText(chars);
    }
}

function MyStreamWriter(filename,
    type,        ///< adTypeText (default) or adTypeBinary
    strLang,     ///< adodb.Streamで入出力する言語："Shift_JIS"、"UTF-8"、"EUC-jp"、"ASCII"、etc (注意：ASCIIを包含するもののみ使用可。"UNICODE"は使用不可)
    saveoption)  ///< adSaveCreateOverWrite (default) or adSaveCreateNotExist
{
    MyStream.call(this, type, strLang);
    var fp = this.Stream();

    var errorLines = "";

    this.bBOM = false; ///< UTF-8のとき、BOMを出力するかどうか
    this.saveoption = (saveoption ? saveoption : adSaveCreateOverWrite); ///< adSaveCreateOverWrite (default) or adSaveCreateNotExist
    this.tee = null; // teeには、documentが設定されることがあるので、write/writeln等を使うこと。
    
    if(!filename) {
      alert("Invalid filename:" + filename);
    }

    this.write = this.Write = function MyStreamWriter_write(str) {
        fp.WriteText(str.replace(/\r?\n/g, this.NL), adWriteChar);
        if (this.tee) {
            this.tee.write(str);
        }
    }

    this.writeln = function MyStreamWriter_writeln(line) {
        this.write(line + this.NL);
    }

    this.writeline = function MyStreamWriter_writeln(line) {
        this.write(line + this.NL);
    }

    this.WriteLine = function MyStreamWriter_WriteLine(lineno, line) {
        try {
            this.write(line + this.NL);
        }
        catch (e2) {
            errorLines += lineno + "\t" + line + this.NL;
        }
    }

    this.Close = this.close = function MyStreamWriter_Close() {
        if(fp) {
            if (fp.Type == adTypeText && strLang == "UTF-8" && !bBOM) {
                // バイナリモードでBOM をスキップして読み込む
                fp.Position = 0;
                fp.Type = 1;    //バイナリモードにする
                fp.Position = 3;    // 先頭3バイト = BOM をスキップする
                var bin = fp.Read(adReadAll);   // バイナリモードでないと Read できない
                fp.Close();

                // BOM無しのデータを書き込む
                WriteWholeFile(filename, bin, adTypeBinary)
            }
            else {
                if(!filename) {
                  alert("Invalid filename:" + filename);
                }
                else {
                    CreateParentFolder(filename);
                    fp.SaveToFile(filename, this.saveoption);
                }
                fp.Close();
            }
            fp = null;
        }
    }

    this.Errorlines = function MyStreamWriter_Errorlines() {
        var ret = errorLines;
        errorLines = "";
        return ret;
    }
}

function ReadWholeFile(filename,
    pos,     ///< read start position (default: 0)
    type,    ///< adTypeText (default) or adTypeBinary
    strLang) ///< adodb.Streamで入出力する言語："Shift_JIS"、"UTF-8"、"EUC-jp"、"ASCII"、etc (注意：ASCIIを包含するもののみ使用可。"UNICODE"は使用不可)
{
    var f = new MyStreamReader(filename, type, strLang);
    if (pos) {
        f.Position = pos;
    }
    try {
        if (type != adTypeText) {
            text = f.Read(adReadAll);
        }
        else {
            text = f.ReadText(adReadAll);
        }
    } catch (e) { }
    f.Close();
    return text;
}

/// テキスト(文字列/バイナリ)をファイルに書込む。
/// 指定ファイル名の上位フォルダが無ければ作成する。
function WriteWholeFile(outfilename, WholeText,
    type,        ///< adTypeText (default) or adTypeBinary
    strLang,     ///< adodb.Streamで入出力する言語："Shift_JIS"、"UTF-8"、"EUC-jp"、"ASCII"、etc (注意：ASCIIを包含するもののみ使用可。"UNICODE"は使用不可)
    _saveoption, ///< adSaveCreateOverWrite (default) or adSaveCreateNotExist
    _bBOM)       ///< UTF-8のとき、BOMを出力するかどうか
{
    CreateParentFolder(outfilename);
    var fp = new MyStreamWriter(outfilename, type, strLang, _saveoption, _bBOM);
    fp.Write(WholeText);
    fp.Close();
}

function MyWriterTee(outfilename, tee, prefix, type, strLang) {
    MyStreamWriter.call(this, outfilename, type, strLang);
    this.tee = tee;
    if (prefix) {
        this.write(prefix);
    }
}

function MyNop()
{
}

function MyNopWriter()
{
	this.string  = "";
	this.write   = MyNop;
	this.writeln = MyNop;
	this.clear   = MyNop;
}

function MyStringWriter(isValid) {
    this.string = "";

    this.isValid = !(isValid === false);

    if (this.isValid) {
        this.write = function MyStringWriter_Write(str) {
            this.string = this.string + str;
        }

        this.writeln = function MyStringWriter_WriteLine(str) {
            this.write(str + "\n");
        }

        this.clear = function MyStringWriter_WriterClear() {
            this.string = "";
        }
    }
    else {
        this.write = MyNop;
        this.writeln = MyNop;
        this.clear = MyNop;
    }
}
