function setStyleDisplayOfRule(rule)
{
	var style = rule.style;
	switch(rule.selectorText) {
		case ".cIdno":
			style.display = (document.getElementById("chkIdno")   .checked ? '':'none');
			break;
		case ".cGenbun":
			style.display = (document.getElementById("chkGenbun") .checked ? '':'none');
			break;
		case ".cYakubun":
			style.display = (document.getElementById("chkYakubun").checked ? '':'none');
			break;
		case ".cYosano":
			style.display = (document.getElementById("chkYosano") .checked ? '':'none');
			break;
		case ".cRoman":
			style.display = (document.getElementById("chkRoman")  .checked ? '':'none');
			break;
		case ".trNotes":
			style.display = (document.getElementById("chkNotes")  .checked &&
			                 document.getElementById("chkGenbun") .checked ? '':'none');
			break;
		case ".trSource":
			style.display = (document.getElementById("chkSource") .checked &&
			                 document.getElementById("chkGenbun") .checked ? '':'none');
			break;
		case ".trRevise":
			style.display = (document.getElementById("chkRevise") .checked &&
			                 document.getElementById("chkGenbun") .checked ? '':'none');
			break;
		case ".trTitle":
			style.display = (document.getElementById("chkGenbun") .checked||
			                 document.getElementById("chkYakubun").checked ? '':'none');
			break;
		case ".trAddr":
			style.display = (document.getElementById("chkAddr")   .checked ? '':'none');
			break;
		case ".trImage":
			style.display = (document.getElementById("chkImage")  .checked ? '':'none');
			break;
		case "RT":
		case "RP":
		case "rt":
		case "rp":
			style.display = (document.getElementById("chkRuby")  .checked ? '':'none');
			break;
	}
}
function setStyleDisplay()
{
	var myStyleSheet = document.getElementById("myStyleSheet");
	if(myStyleSheet.styleSheet!=null) {
		var rules = myStyleSheet.styleSheet.rules;
		for(i=0; i<rules.length; ++i) {
			setStyleDisplayOfRule(rules[i])
		}
	}
	else if(myStyleSheet.sheet.cssRules!=null) {
		var cssRules = myStyleSheet.sheet.cssRules;
		for(i=0; i<cssRules.length; ++i) {
			setStyleDisplayOfRule(cssRules[i])
		}
	}
	try {
		//document.getElementById("tblMain").border=(document.getElementById("chkRuler").checked?1:0);
		if(document.getElementById("chkRuler").checked) {
			document.getElementById("tblMain").border = 1;
			document.getElementById("tblMain").cellSpacing = 0;
		}
		else {
			document.getElementById("tblMain").border = 0;
			document.getElementById("tblMain").cellSpacing = 4;
		}
	}
	catch(e) { }
	var i;
	var CheckBoxes = document.getElementById("trCheckBoxes").innerHTML.split("id=");
	var strCheckedButtons = "";
	for(i=1;i<CheckBoxes.length;++i) {
		if(result=/^"?(chk[A-Z][a-z]+)"? /.exec(CheckBoxes[i]), result!=null) {
			var idCheckBox = result[1];
			if(document.getElementById(idCheckBox).checked) {
				strCheckedButtons = strCheckedButtons + "," + idCheckBox;
			}
		}
	}
	var expires = new Date();
	expires.setTime(expires.getTime()+(30*24*60*60*1000));
	window.top.document.cookie = "CheckedButtons="+strCheckedButtons.substring(1)+";expires="+expires.toGMTString();
	//alert("new = "+window.top.document.cookie);
}

var arrayStyleIDs     = "cIdno,cGenbun,cYakubun,cYosano,cRoman,trNotes,trSource,trRevise,trAddr,trImage".split(",");
var strCheckedButtons = "chkIdno,chkGenbun,chkYakubun,chkYosano,chkNotes,chkSource,chkAddr,chkImage,chkRuler,chkRuby";
if(result=/CheckedButtons=([A-Za-z0-9_,]*)/.exec(window.top.document.cookie), result!=null) {
	strCheckedButtons = new String(result[1]);
}
document.write("<STYLE id=\"myStyleSheet\">\n");
for(i=0;i<arrayStyleIDs.length;++i) {
	var styleID = arrayStyleIDs[i];
	document.write("."+styleID+" {display:"+(strCheckedButtons.indexOf(styleID.replace(/^tr/,"chk"))>=0 ? "table-row"  : 
	                                         strCheckedButtons.indexOf(styleID.replace(/^c/, "chk"))>=0 ? "inline" : "none") + ";}\n");
}
document.write("RT {display:"+(strCheckedButtons.indexOf("chkRuby")>=0 ? "inline" : "none") + ";}\n");
document.write("RP {display:"+(strCheckedButtons.indexOf("chkRuby")>=0 ? "inline" : "none") + ";}\n");
document.write("</STYLE>\n");

function setCheckBoxes()
{
	var i;
	var CheckBoxes = document.getElementById("trCheckBoxes").innerHTML.split("id=");
	for(i=1;i<CheckBoxes.length;++i) {
		if(result=/^[""]?(chk[A-Z][a-z]+)/.exec(CheckBoxes[i])) {
			var idCheckBox = result[1];
			document.getElementById(idCheckBox).checked = (strCheckedButtons.indexOf(idCheckBox)>=0 ? true : false);
		}
	}
	setStyleDisplay();
}

function writeDisplySettingButtons()
{
	document.write(
		'<TABLE border=1>' +
		'<TR>' +
		'<TH nowrap rowspan=2 valign=middle><FONT size=6><B>表示設定</B></FONT></TH>' +
		'<TH id=thchkIdno    nowrap>番号</TH>' +
		'<TH id=thchkGenbun  nowrap>本文</TH>' +
		'<TH id=thchkYakubun nowrap>現代語訳</TH>' +
		'<TH id=thchkYosano  nowrap>與謝野晶子訳</TH>' +
		'<TH id=thchkRoman   nowrap>ローマ字版</TH>' +
		'<TH id=thdchkNotes  nowrap>注釈</TH>' +
		'<TH id=thchkSource  nowrap>出典</TH>' +
		'<TH id=thchkRevise  nowrap>校訂</TH>' +
		'<TH id=thchkAddr    nowrap>著作権</TH>' +
		'<TH id=thchkImage   nowrap>絵</TH>' +
		'<TH id=thchkRuler   nowrap>罫線</TH>' +
		'<TH id=thchkRuby    nowrap>ルビ</TH>' +
		(window.name == window.top.name ? '':
		'<TD rowspan=2><INPUT type=button value="全画面" onclick="window.top.location.href=window.location.href;"></TD>') +
		'</TR>' +
		'<TR id=trCheckBoxes>' +
		'<TD id=tdchkIdno     align=center><INPUT type=checkbox id=chkIdno     onclick="setStyleDisplay()"></TD>' +
		'<TD id=tdchkGenbun   align=center><INPUT type=checkbox id=chkGenbun   onclick="setStyleDisplay()"></TD>' +
		'<TD id=tdchkYakubun  align=center><INPUT type=checkbox id=chkYakubun  onclick="setStyleDisplay()"></TD>' +
		'<TD id=tdchkYosano   align=center><INPUT type=checkbox id=chkYosano   onclick="setStyleDisplay()"></TD>' +
		'<TD id=tdchkRoman    align=center><INPUT type=checkbox id=chkRoman    onclick="setStyleDisplay()"></TD>' +
		'<TD id=tdchkNotes    align=center><INPUT type=checkbox id=chkNotes    onclick="setStyleDisplay()"></TD>' +
		'<TD id=tdchkSource   align=center><INPUT type=checkbox id=chkSource   onclick="setStyleDisplay()"></TD>' +
		'<TD id=tdchkRevise   align=center><INPUT type=checkbox id=chkRevise   onclick="setStyleDisplay()"></TD>' +
		'<TD id=tdchkAddr     align=center><INPUT type=checkbox id=chkAddr     onclick="setStyleDisplay()"></TD>' +
		'<TD id=tdchkImage    align=center><INPUT type=checkbox id=chkImage    onclick="setStyleDisplay()"></TD>' +
		'<TD id=tdchkRuler    align=center><INPUT type=checkbox id=chkRuler    onclick="setStyleDisplay()"></TD>' +
		'<TD id=tdchkRuby     align=center><INPUT type=checkbox id=chkRuby     onclick="setStyleDisplay()"></TD>' +
		'</TR>' +
		'</TABLE>'
	);
	setCheckBoxes();
}
