var startTime = new Date().getTime() //処理開始時刻
var procTimes = new Array(); //処理開始時刻からの経過時間を添字とする配列。単位はミリ秒だが分解能はティック(1/64秒)単位。各要素は同一ティック内に発生したトレースのIDを到着順に保持する配列となる。

// Constants for ActiveXObject("adodb.Stream")
var adModeRead           = 1; //読み取り専用の権限
var adModeWrite          = 2; //書き込み専用の権限
var adModeShareDenyWrite = 8; //書き込み権限によるほかのユーザーからの接続を禁止します。
var adTypeBinary = 1;  // 保存データの種類:バイナリ
var adTypeText   = 2;  // 保存データの種類:テキスト
var adReadAll    = -1; // 読み込み方法:全行
var adReadLine   = -2; // 読み込み方法:一行ごと
var adWriteChar  = 0;  // 書き込み方法:改行なし
var adWriteLine  = 1;  // 書き込み方法:改行あり
var adSaveCreateNotExist  = 1; // ファイル保存方法:ない場合は新規作成
var adSaveCreateOverWrite = 2; // ファイル保存方法:ある場合は上書き

function trace(id)
{
	var currTime = new Date().getTime() - startTime;
	if(procTimes[currTime] == null) procTimes[currTime] = new Array();
	procTimes[currTime][procTimes[currTime].length] = id;
}

/// ファイル全体を読み込んで文字列で返す。
/// テキストファイルを読み込んだ場合、改行文字の種類(CRLFかLFのみ)をchNLに設定する。

function CreateParentFolder(FullName)
{
	var result = null
	if(result=/^(.*)[\\\/]([^\\\/]*)$/.exec(FullName),result) {
		var PathName = result[1]+"";
		if(!fso.FolderExists(PathName)) {
			CreateParentFolder(PathName);
			MyLog("\tCreateFolder\t"+PathName);
			fso.CreateFolder(PathName);
		}
	}
}

function MyStream(filename,
  type,       ///< adTypeText (default) or adTypeBinary
  strLang)    ///< adodb.Streamで入出力する言語："Shift_JIS"、"UTF-8"、"EUC-jp"、"ASCII"、etc (注意：ASCIIを包含するもののみ使用可。"UNICODE"は使用不可)
{
  var fp = new ActiveXObject("ADODB.Stream");
  fp.Type = (type ? type : adTypeText);
  fp.Charset = (strLang ? strLang : "UTF-8");
  fp.Open();

  fp.Position = 0;
  
  this.Stream = function MyStream_Stream() {
    return fp;
  }
  
  this.NL = "\r\n";
  
  this.Position = function MyStream_Position() {
      return fp.Position;
  }

  this.setPosition = function MyStream_setPosition(value) {
      fp.Position = value;
  }
  
  this.Size = function MyStream_Size() {
      return fp.Size;
  }

  this.Close = function MyStream_Close()
  {
    fp.Close();
  }
}

function MyStreamReader(filename,
  type,       ///< adTypeText (default) or adTypeBinary
  strLang)    ///< adodb.Streamで入出力する言語："Shift_JIS"、"UTF-8"、"EUC-jp"、"ASCII"、etc (注意：ASCIIを包含するもののみ使用可。"UNICODE"は使用不可)
{
  MyStream.call(this, type, strLang);
  var fp = this.Stream();
  
  fp.LoadFromFile(filename);

  this.ReadAll = function MyFileReader_ReadAll()
  {
    return fp.ReadText(adReadAll);
  }

  this.ReadLine = function MyFileReader_ReadLine()
  {
    return fp.ReadText(adReadLine);
  }

  this.Read = function MyFileReader_Read(chars)
  {
    return fp.ReadText(chars);
  }
}

function MyStreamWriter(filename,
  type,        ///< adTypeText (default) or adTypeBinary
  strLang)     ///< adodb.Streamで入出力する言語："Shift_JIS"、"UTF-8"、"EUC-jp"、"ASCII"、etc (注意：ASCIIを包含するもののみ使用可。"UNICODE"は使用不可)
{
  MyStream.call(this, type, strLang);
  var fp = this.Stream();

  var errorLines = "";

  this.bBOM = false; ///< UTF-8のとき、BOMを出力するかどうか
  this.saveoption = adSaveCreateOverWrite; ///< adSaveCreateOverWrite (default) or adSaveCreateNotExist
  this.tee = null;
  
  CreateParentFolder(filename);
  //fp.Mode = adModeShareDenyWrite; // 省略するかadModeShareDenyWrite指定ならOKだが、adModeWrite指定するとSaveToFileでエラーになる。
  fp.Open();
  
  this.write = function myWriter_write(str)
  {
    fp.Write(str);
    if(this.tee) {
      this.tee.write(str);
    }
  }

  this.Write = function myWriter_Write(str)
  {
    this.write(str);
  }

  this.writeln = function myWriter_writeln(line)
  {
    this.write(line+this.NL);
  }

  this.WriteLine = function myWriter_WriteLine(lineno, line)
  {
    try {
      this.writeln(line);
    }
    catch(e2) {
      errorLines += lineno+"\t"+line+this.NL;
    }
  }

  this.Close = this.close = function myWriter_Close()
  {
    if(fp.Type == adTypeText && strLang == "UTF-8" && !bBOM) {
      // バイナリモードでBOM をスキップして読み込む
      fp.Position = 0;
      fp.Type = 1;    //バイナリモードにする
      fp.Position = 3;    // 先頭3バイト = BOM をスキップする
      var bin = fp.Read(adReadAll);   // バイナリモードでないと Read できない
      fp.Close();

      // BOM無しのデータを書き込む
      WriteWholeFile(outfilename, bin, adTypeBinary)
    }
    else {
      fp.SaveToFile(outfilename, saveoption);
      fp.Close();
    }
  }

  this.Errorlines = function myWriter_Errorlines()
  {
    var ret = errorLines;
    errorLines = "";
    return ret;
  }
}

function writeLine(fp, lineno, line)
{
  fp.WriteLine(lineno, line);
  return fp.ErrorLines();
}

function readWholeFile(filename,
  pos,     ///< read start position (default: 0)
  type,    ///< adTypeText (default) or adTypeBinary
  strLang) ///< adodb.Streamで入出力する言語："Shift_JIS"、"UTF-8"、"EUC-jp"、"ASCII"、etc (注意：ASCIIを包含するもののみ使用可。"UNICODE"は使用不可)
{
  var f = new myStreamReader(filename, type, strLang);
  if(pos) {
    f.Position = pos;
  }
  try {
    if(type != adTypeText) {
      text = f.Read(adReadAll);
    }
    else {
      text = f.ReadText(adReadAll);
    }
  } catch(e) { }
  f.Close();
  return text;
}

/// テキスト(文字列/バイナリ)をファイルに書込む。
/// 指定ファイル名の上位フォルダが無ければ作成する。
function writeWholeFile(outfilename, WholeText,
  type,        ///< adTypeText (default) or adTypeBinary
  strLang,     ///< adodb.Streamで入出力する言語："Shift_JIS"、"UTF-8"、"EUC-jp"、"ASCII"、etc (注意：ASCIIを包含するもののみ使用可。"UNICODE"は使用不可)
  _saveoption, ///< adSaveCreateOverWrite (default) or adSaveCreateNotExist
  _bBOM)       ///< UTF-8のとき、BOMを出力するかどうか
{
  var fp = new myStreamWriter(outfilename, type, strLang, _saveoption,_bBOM);
  fp.Write(WholeText);
  fp.Close();
}

function myWriterTee(outfilename, tee, prefix)
{
	this.fp = new MyStreamWriter(outfilename);
	this.close = myWriterClose;
	this.write = myWriterWrite;
	this.writeln = myWriterWriteLine;
	if(prefix) {
		this.write(prefix);
	}
	this.tee = tee;
}

function myStringWriter()
{
	this.string  = "";

	this.write = function myStringWrite(str)
  {
  	this.string = this.string + str;
  }

	this.writeln = function myStringWriteLine(str)
  {
  	this.write(str+"\n");
  }

	this.clear = function myStringWriterClear()
  {
  	this.string  = "";
  }
}

function myNop()
{
}

function myNopWriter()
{
	this.string  = "";
	this.write   = myNop;
	this.writeln = myNop;
	this.clear   = myNop;
}

function myStringWriter2(isValid)
{
	this.string  = "";
	if(isValid) {
		this.write   = myStringWrite;
		this.writeln = myStringWriteLine;
		this.clear   = myStringWriterClear;
	}
	else {
		this.write   = myNop;
		this.writeln = myNop;
		this.clear   = myNop;
	}
}
