/***********************************************************************************************
 *
 * t@Co̓Tu[`W
 *
 *  ̃W[̃p[^͈ȉ̒ʂłBKvɉăCvOŏĂB
 *    var LogFileName;     // oLOGt@C
 *    var bLogStdErr;      // OWG[o(CScript̃R\[)ɂo͂邩ǂ
 *    var fncLogTimestamp; // O̊esɃ^CX^vtꍇ͌ݓ擾֐AȂꍇnullݒ肷B
 *    var LogOutputMode;   // ForWriting : Ot@C̐擪珑݂܂B ForAppending : Ot@C̍Ōɒǉď݂܂B(ftHg)
 *  ȉ̕ϐƊ֐`܂B
 *    var fso = new ActiveXObject("Scripting.FileSystemObject");
 *    function log(msg);                               // Oo͂B
 *    function logClose();                             // ÕN[YB
 *    function ReadWholeFile(filename);                // t@CŜǂݍ񂾃eLXg()ԂB
 *    function CreateParentFolder(pathname);           // wpX̏ʃtH_΍쐬B
 *    function WriteWholeFile(outfilename, WholeText); // eLXg()t@CɏށBwt@C̏ʃtH_΍쐬B
 *    /// t@C/tH_Iw(SI/񊮑Sv/K\/t@CI֐Ăяo)Ƀ}b`邩ǂ𔻒肷B
 *    function Select(
 *      Name,       ///< t@C/tH_
 *      Selection); ///< Iw(SI/񊮑Sv/K\/t@CI֐Ăяo)
 *    /// wtH_̃t@CŁAt@CIwɃ}b`t@C񋓂At@C̔zŕԂB
 *    function Files(
 *      folder,        ///< string^FwtH_̃pXAobject^Ffso.FolderIuWFNg
 *      FileSelection, ///< t@CIw(SI/񊮑Sv/K\/t@CI֐Ăяo)BȗƑSIɂȂB
 *      files);        ///< ^[lԋppzBȗƐVɊmۂB
 *    /// wtH_z̃tH_ŁAtH_IwɃ}b`tH_ċAIɗ񋓂ApX̔zŕԂB(wtH_̂͏)
 *    function Folders(
 *      folder,          ///< string^FwtH_̃pXAobject^Ffso.FolderIuWFNg
 *      FolderSelection, ///< tH_Iw(SI/񊮑Sv/K\/t@CI֐Ăяo)BȗƑSIɂȂB
 *      folders);        ///< ^[lԋppzBȗƐVɊmۂB
 *
 ************************************************************************************************/
//#EN:/***********************************************************************************************
//#EN: *
//#EN: * File input / output subroutines
//#EN: *
//#EN: ************************************************************************************************/

//**********************************************************************************************
// Copyright (C) 2017,2020 Magnescale Co., Ltd. All rights reserved.
// The present sample programs are released under the MIT license.
// https://opensource.org/licenses/mit-license.php 
//**********************************************************************************************

var fso = new ActiveXObject("Scripting.FileSystemObject");

// Constants for ActiveXObject("adodb.Stream")
var adModeRead           = 1; //ǂݎp̌
var adModeWrite          = 2; //ݐp̌
var adModeShareDenyWrite = 8; //݌ɂق̃[U[̐ڑ֎~܂B
var adTypeBinary = 1;  // ۑf[^̎:oCi
var adTypeText   = 2;  // ۑf[^̎:eLXg
var adReadAll    = -1; // ǂݍݕ@:Ss
var adReadLine   = -2; // ǂݍݕ@:s
var adWriteChar  = 0;  // ݕ@:sȂ
var adWriteLine  = 1;  // ݕ@:s
var adSaveCreateNotExist  = 1; // t@Cۑ@:Ȃꍇ͐VK쐬
var adSaveCreateOverWrite = 2; // t@Cۑ@:ꍇ͏㏑

//***********************************************************************************************
//
// ̃TvvÕp[^łBKvɉďĂB
//#EN: These are parameters of this sample program. Please rewrite as necessary.
//
var strLang = "UTF-8"; /* adodb.Streamœo͂錾F"Shift_JIS"A"UTF-8"A"EUC-jp"A"ASCII"Aetc (ӁFASCII܂̂̂ݎgpB"UNICODE"͎gps) */ /*#EN: Language for input and output in adodb.Stream: "Shift_JIS", "UTF-8", "EUC-jp", "ASCII", etc. (Note: Only those languages that contain ASCII can be used. "UNICODE" is not available.) */
var bBOM = true; /* UTF-8̂ƂABOMo͂邩ǂ */ /*#EN: Whether or not to output BOM in UTF-8 */
var LogFileName; // oLOGt@C
var bLogStdErr;  /* OWG[o(CScript̃R\[)ɂo͂邩ǂ */ /*#EN: Whether to output the log to standard error output (CScript's console) */
var fncLogTimestamp = (typeof(strYYYY_MM_DD_HH_MM_SS)=="function" ? strYYYY_MM_DD_HH_MM_SS : null); /* O̊esɃ^CX^vtꍇ͌ݓ擾֐AȂꍇnullݒ肷B*/ /*#EN: If a timestamp is added to each line of the log, set the function name to get the current date and time. */
var LogOutputMode = ForAppending; // ForWriting : Ot@C̐擪珑݂܂B ForAppending : Ot@C̍Ōɒǉď݂܂B
//
//***********************************************************************************************

var chNL = null; /* s̎(CRLFLF̂)BReadWholeFileŐݒ肳AWriteWholeFileŎQƂB*/ /*#EN: Type of line breaks (CRLF or LF only). Set in ReadWholeFile and referenced in WriteWholeFile.*/
var fpLog;
var bStdErrorIsUsed = 0;
var LogMessagePrefix = null;

/// Oo͂B
///#EN: Outputs a log.
/// FileSystemObjectgpBāAstrLang̎w͖B
///#EN: Use FileSystemObject. Therefore, strLang is ignored.
function log(msg, force)
{
  var line = (typeof(fncLogTimestamp)=="function" ? fncLogTimestamp() + ":" : "") + (LogMessagePrefix != null ? LogMessagePrefix + ":" : "") + msg.replace(/\r?\n/g, "\r\n");
  if(bLogStdErr||force) {
    try {
      WScript.StdErr.WriteLine(line);
      bStdErrorIsUsed = 1;
    }
    catch(ex) {
      bLogStdErr = false;
      var msg = "Exception("+typeof(ex)+":"+ex.message+") occured on WScript.StdErr.WriteLine(\""+line+"\").";
      switch(bStdErrorIsUsed) {
      case 0:
        bStdErrorIsUsed = -1;
        log(msg);
        Error(msg);
        return;;
      case 1:
        bStdErrorIsUsed = 2;
        log(msg);
        Error(msg);
        break;
      case -1:
      case 2:
        return;
      default:
        stop; //bug
      }
    }
  }
  if(!fpLog) {
    if(LogFileName) {
      CreateParentFolder(LogFileName);
      fpLog = fso.OpenTextFile(LogFileName, LogOutputMode, true);
    }
  }
  if(fpLog) {
    fpLog.WriteLine(line);
  }
}

/// ÕN[YB
///#EN: Close the log.
function logClose()
{
  if(fpLog) {
    fpLog.Close();
    fpLog = null;
  }
}

/// t@CŜǂݍŕŕԂB
/// eLXgt@Cǂݍ񂾏ꍇAs̎(CRLFLF̂)chNLɐݒ肷B
///#EN: Reads the whole file and returns it as a string.
///#EN: If a text file is read, set the line feed type (CRLF or LF only) to chNL.
function ReadWholeFile(filename,
  type, ///< adTypeText (default) or adTypeBinary
  pos)  ///< read start position (default: 0)
{
  if(!type) {
    type = adTypeText;
  }
  var text="";
  var f = new ActiveXObject("ADODB.Stream");
  f.Type = type;
  f.charset = strLang;
  if(pos) {
    f.Position = pos;
  }
  f.Open();
  try {
    f.LoadFromFile( filename );
    if(type != adTypeText) {
      text = f.Read(adReadAll);
    }
    else {
      chNL = "\n"; // ǂݍ񂾃t@CCR1ƂAsLF݂̂Ƃ݂ȂB
      text = f.ReadText(adReadAll).replace(/[\r]/g, // CRB
        function() {
          chNL = "\r\n"; // CR1ȏ゠΁AsCRLFƂ݂ȂB
          return "";
        }
      );
    }
  } catch(e) { }
  f.Close();
  return text;
}

/// wpX̏ʃtH_΍쐬B
/// ~iwpX"/""\"ŏIĂꍇ́AwpX̃tH_A΍쐬Bj
function CreateParentFolder(pathname)
{
  pathname = pathname.replace(/[\\\/]$/, ""); // uwpX"/""\"ŏIĂꍇ́AwpX̃tH_A΍쐬v𒆎~邽߂ɒǉB
  if(result=/^(.*)[\\\/][^\\\/]*$/.exec(pathname)) {
    var parentFolderName = result[1] + "";
    if(!fso.FolderExists(parentFolderName)) {
      CreateParentFolder(parentFolderName);
      log("CreateParentFolder: mkdir "+parentFolderName);
      fso.CreateFolder(parentFolderName);
    }
  }
}

/// eLXg(/oCi)t@CɏށB
/// wt@C̏ʃtH_΍쐬B
/// o͂̉schNL̎wɏ]B
///#EN: Write text (string/binary) to a file.
///#EN: If there is no high-level folder for the specified file name, it is created.
///#EN: The line feed character of the output follows the specification of chNL.
function WriteWholeFile(outfilename, WholeText,
  type,       ///< adTypeText (default) or adTypeBinary
  saveoption) ///< adSaveCreateOverWrite (default) or adSaveCreateNotExist
{
  if(!type) {
    type = adTypeText;
  }
  if(!saveoption) {
    saveoption =adSaveCreateOverWrite;
  }
  CreateParentFolder(outfilename);
  var fp = new ActiveXObject("ADODB.Stream");
  //fp.Mode = adModeShareDenyWrite; // ȗ邩adModeShareDenyWritewȂOKAadModeWritew肷SaveToFileŃG[ɂȂB
  fp.Type = type;
  if(type == adTypeText) {
    fp.charset = strLang;
    fp.Open();
    fp.WriteText(WholeText.replace(/\r?\n/g, (chNL ? chNL : "\r\n")), adWriteChar);
    if(strLang != "UTF-8" || bBOM) {
      fp.SaveToFile(outfilename, saveoption);
      fp.Close();
    }
    else {
      // oCi[hBOM XLbvēǂݍ
      fp.Position = 0;
      fp.Type = 1;    //oCi[hɂ
      fp.Position = 3;    // 擪3oCg = BOM XLbv
      var bin = fp.Read(adReadAll);   // oCi[hłȂ Read łȂ
      fp.Close();

      // BOM̃f[^
      WriteWholeFile(outfilename, bin, adTypeBinary)
    }
  }
  else {
    fp.Open();
    fp.Write(WholeText);
    fp.SaveToFile(outfilename, saveoption);
    fp.Close();
  }
}

/// t@C/tH_Iw(SI/񊮑Sv/K\/t@CI֐Ăяo)Ƀ}b`邩ǂ𔻒肷B
///#EN: Checks whether the file/folder name matches the selection specification (select all, match whole string, regular expression, call file selection function).
function Select(
  Name,      ///< t@C/tH_
  Selection) ///< Iw(SI/񊮑Sv/K\/t@CI֐Ăяo)
{
  var selected = false;
  switch(typeof Selection) {
  case "undefined": // w薳FSI
    selected = true;
    break;
  case "string": // Sv
    selected = (Selection == Name);
    break;
  case "function": // t@CI֐Ăяo
    selected = Selection(Name);
    break;
  case "object":
    if(!Selection) { // nullwFSI
      selected = true;
    }
    else if(Selection instanceof RegExp) { // K\
      selected = Selection.test(Name);
    }
    break;
  }
  return selected;
}

/// wtH_̃t@CŁAt@Ct@CIwɃ}b`t@C񋓂At@C̔zŕԂB
///#EN: Enumerates files that belong to the specified folder and whose names match the FileSelection, and returns an array of file names.
function Files(
  folder,        ///< string^FwtH_̃pXAobject^Ffso.FolderIuWFNg
  FileSelection, ///< t@CIw(SI/񊮑Sv/K\/t@CI֐Ăяo)BȗƑSIɂȂB
  files)         ///< ^[lԋppzBȗƐVɊmۂB
{
  var InputPathName = (typeof(folder)=="string" ? folder                : folder.Path+"\\");
  var f             = (typeof(folder)=="string" ? fso.GetFolder(folder) : folder);
  var fc = new Enumerator(f.files);
  if(!files) {
    files = new Array();
  }
  for (; !fc.atEnd(); fc.moveNext())
  {
    var FullName = fc.item()+"";
    var FileName = FullName.substring(InputPathName.length,FullName.length);
    if(Select(FileName, FileSelection)) {
      files[files.length] = FileName;
    }
  }
  return files;
}

/// wtH_z̃tH_ŁAtH_tH_IwɃ}b`tH_ċAIɗ񋓂ApX̔zŕԂB(wtH_̂͏)
///#EN: Recursively enumerates the folders under the specified folder whose names match the FolderSelection specification, and returns an array of path names. (Except for the specified folder itself.)
function Folders(
  folder,          ///< string^FwtH_̃pXAobject^Ffso.FolderIuWFNg
  FolderSelection, ///< tH_Iw(SI/񊮑Sv/K\/t@CI֐Ăяo)BȗƑSIɂȂB
  folders)         ///< ^[lԋppzBȗƐVɊmۂB
{
  var InputPathName;
  if(typeof(folder)=="string") {
    InputPathName = folder;
    folder = fso.GetFolder(InputPathName);
  }
  else { // fso.FolderIuWFNg
    InputPathName = folder.Path+"\\";
  }
  if(!folders) {
    folders = new Array();
  }
  var fc = new Enumerator(folder.SubFolders);
  for (; !fc.atEnd(); fc.moveNext())
  {
    var PathName = fc.item()+"\\";
    var FolderName = PathName.substring(InputPathName.length,PathName.length-1);
    if(Select(FolderName, FolderSelection)) {
      folders[folders.length] = PathName;
    }
    Folders(PathName, FolderSelection, folders);
  }
  return folders;
}

function isArray(obj) {
    return Object.prototype.toString.call(obj) === '[object Array]';
}
    
function CopyFiles(src,tgt,selection,func)
{
    MoveFiles(src,tgt,selection, (func ? func : "Copy"))
}
    
function MoveFiles(src,tgt,selection,func)
{
    switch(func) {
    case "Copy":
    case "Move":
    case "NOP":
        break;
    default:
        if(func) {
            stop
        }
        func = "Move";
    }
    switch(typeof selection) {
    case "string":
        break;
    case "undefined": // w薳
        selection = "";
        break;
    case "object":
        if(!selection) { // nullw
            selection = "";
        }
        else if(selection instanceof Array) { // zw
            for(var ix in selection) {
                var elem = selection[ix];
                log(func+"Files(\n\t"+src+",\n\t"+tgt+ (selection? ",\n\tArray["+ix+"]("+elem+")" : "") +")");
                MoveFiles(src,tgt,elem,func)
            }
            return;
        }
        else if(selection instanceof RegExp) { // K\
            var files = Files(src.replace(/[\\\/]?$/,"/"), selection);
            log(func+"Files(\n\t"+src+",\n\t"+tgt+ (selection? ",\n\tRegExp("+selection+"):("+files+")" : "") +")");
            MoveFiles(src, tgt, files, func); // zwōċAĂяo
            return;
        }
        else { // nullłzłȂIuWFNg
            stop;
        }
        break;
    default:
        stop
    }
    log(func+"Files(\n\t"+src+",\n\t"+tgt+ (selection? ",\n\t"+selection: "") +")");
    CreateParentFolder(tgt+"\\xxxx");
    switch(func) {
    case "Move":
      CreateParentFolder(tgt+"\\__delete\\xxxx");
      if(selection) {
          fso.MoveFile(tgt + "\\" + selection, tgt+"\\__delete\\");
      }
      try {
        fso.MoveFile(src + "\\" + selection, tgt+"\\");
      }
      catch(ex) {
        log("Can not Move File: "+ex.message+"\n"+
          "\tfrom: \""+src + "\\" + selection+"\",\n"+
          "\t  to: \""+tgt+"\\\"");
        fso.MoveFile(tgt + "\\__delete\\" + selection, tgt+"\\");
      }
      DeleteFolder(tgt+"\\__delete");
      break;
    case "Copy":
      fso.CopyFile(src + "\\" + selection, tgt+"\\");
      break;
    case "Nop":
      break;
    default:
      stop
    }
}
    
function DeleteFiles(tgt,func)
{
    try {
        if(!func || func!="Nop") {
            fso.DeleteFile(tgt, true);
        }
        log("fso.DeleteFile(\n\t"+tgt+")");
    }
    catch(ex) {
        var ex_number = ex.number + (ex.number < 0 ? 0x100000000 : 0);;
        switch(ex_number) {
        case 0x800a0005: // vV[W̌ĂяoA܂͈słB
        case 0x800a0035: //"t@C܂B":
        case 0x800a004c: //"pX܂B":
            return false;
        default:
            log("fso.DeleteFile("+tgt+"): Exception(0x"+ex_number.toString(16)+"): "+ex.message);
            stop
        }
    }
}
    
function CopyFolder(src,tgt,chkExists,func)
{
    if(!chkExists || FileExists(src+chkExists)) {
        CreateParentFolder(tgt);
        DeleteFolder(tgt,func);
        WScript.Sleep(100);
        log("CopyFolder(\n\t"+src+",\n\t"+tgt+")");
        if(!func || func!="Nop") {
            fso.CopyFolder(src.replace(/[\\\/]$/,""), tgt.replace(/[\\\/]$/,""), true);
        }
    }
}

function DeleteFolder(tgt,func)
{
    if(fso.FolderExists(tgt.replace(/[\\\/]$/,""))) {
        log("DeleteFolder(\n\t"+tgt+")");
        if(!func || func!="Nop") {
            for(var retry = 0;; ++retry) {
                try {
                    fso.DeleteFolder(tgt.replace(/[\\\/]$/,""), true);
                    break;
                }
                catch(ex) {
                    var ex_number = ex.number + (ex.number < 0 ? 0x100000000 : 0);;
                    switch(ex_number) {
                    case 0x800a0046: //"݂ł܂B":
                        WScript.Sleep(100);
                        if(retry >= 3) {
                            throw ex;
                        }
                        continue;
                    case 0x800a0035: //"t@C܂B":
                    case 0x800a004c: //"pX܂B":
                    default:
                        log("FileExists("+filename+"): fso.CopyFile.Exception(0x"+ex_number.toString(16)+"): "+ex.message+")");
                        stop
                    }
                }
            }
        }
        return true;
    }
    return false;
}

/* ܂ȂB~
function FileExists(filename)
{
    try {
        var parent = fso.GetParentFolderName(filename).replace(/[\\\/]?$/,"\\");;
        fso.CopyFile(filename, parent, true);
        log("FileExists("+filename+"): ɂ͗ȂnYȂ̂Ɂc\n\tfso.CopyFile(\n\t"+filename+",\n\t"+parent+")");
        stop // ɂ͗ȂB
    }
    catch(ex) {
        var ex_number = ex.number + (ex.number < 0 ? 0x100000000 : 0);;
        switch(ex_number) {
        case 0x800a0035: //"t@C܂B":
        case 0x800a004c: //"pX܂B":
            return false;
        case 0x800a0046: //"݂ł܂B":
            return true;
        default:
            log("FileExists("+filename+"): fso.CopyFile.Exception(0x"+ex_number.toString(16)+"): "+ex.message+")");
            stop
        }
    }
}
*/
