<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                xmlns:my="http://localhost"
                version="1.0">
<xsl:output method="text"/>
<msxsl:script language="JScript" implements-prefix="my">
<![CDATA[
var TagNest = -1;
var TagStack = null;
var XmlFlows = null;

function PutXmlFlow(left, right)
{
	//var ix = (TagNest<=2? "-root": "-"+TagStack[1]+"-"+TagStack[2]);
	//var ix = (TagNest<=1? "-root": "-"+TagStack[1]);
	var ix = (TagNest<=0? "-root": "");
	if(XmlFlows[ix]==null) {
		XmlFlows[ix] = new Array();
	}
	var XmlFlow = "\""+left+"\"->\""+right+"\""
	if(XmlFlows[ix][XmlFlow]==null)
	     XmlFlows[ix][XmlFlow]  = 1;
	else XmlFlows[ix][XmlFlow] += 1;
}

function startFile()
{
	TagNest = 0;
	TagStack = new Array();
	XmlFlows = new Array();
	return "";
}
function beginNode(nodeName)
{
	TagNest++;
	TagStack[TagNest] = nodeName;
	if(TagNest>=1) PutXmlFlow(TagStack[TagNest-1], TagStack[TagNest]);
	return "";
}
function endNode(nodeName)
{
	TagStack[TagNest] = null;
	TagNest--;
	return "";
}
function endFile()
{
	var str = "";
	for(XmlFlowName in XmlFlows) {
		str = str + "{\n"
		          + "\trankdir=LR;\n"
		for(XmlFlow in XmlFlows[XmlFlowName]) {
			str = str + "\t"+XmlFlow+" [label=\"" + XmlFlows[XmlFlowName][XmlFlow] +"\"]\n";
		}
		str = str + "}\n";
	}
	XmlFlows = null;
	TagStack = null;
	return str;
}
]]>
</msxsl:script>
<xsl:template match="/">
<xsl:value-of select="my:startFile()"/>
<xsl:apply-templates select="node()"/>
<xsl:value-of select="my:endFile()"/>
</xsl:template>

<xsl:template match="node()">
<xsl:value-of select="my:beginNode(name())"/>
<xsl:apply-templates select="@* | node()"/>
<xsl:value-of select="my:endNode(name())"/>
</xsl:template>

<xsl:template match='text()'>
</xsl:template>

<xsl:template match="@*">
</xsl:template>

</xsl:stylesheet>
